/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.wizards;

import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.wizards.AbstractDestinationPage;
import com.fold1.eulumdat.tools.wizards.ContainerChooserComposite;
import com.fold1.eulumdat.tools.wizards.DirectoryChooserComposite;
import com.fold1.eulumdat.tools.wizards.ExpandedFilelistComposite;
import com.fold1.eulumdat.tools.wizards.WizardPageOkChecker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExportDestinationPage
extends AbstractDestinationPage
implements WizardPageOkChecker {
    private final IStructuredSelection initialSelection;

    protected ExportDestinationPage(String pageName, IStructuredSelection initialSelection) {
        super(pageName);
        this.initialSelection = initialSelection;
        this.setTitle(pageName);
        this.setDescription("Check the selected files and choose the output destination.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormData containerData = new FormData();
        container.setLayoutData((Object)containerData);
        container.setLayout((Layout)new FormLayout());
        this.sourceStore = new ContainerChooserComposite(container, 0, false);
        FormData source = new FormData();
        source.top = new FormAttachment(0, 0);
        source.left = new FormAttachment(0, 0);
        source.right = new FormAttachment(100);
        this.sourceStore.setLayoutData(source);
        this.sourceStore.setTargetLabelText("Export from:");
        this.sourceStore.setInitialContainer(ExportDestinationPage.validContainerFromSelection(this.initialSelection));
        this.sourceStore.setChecker(this);
        this.sourceStore.addModifyListener(e -> {
            String path = this.sourceStore.getTargetStorePathText();
            try {
                this.selection = Utils.expandSelection(path, Utils.EULUMDAT);
                this.expandedFilelistComposite.setSelection(this.selection);
            }
            catch (CoreException exception) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"File List Expansion Error", (String)exception.getMessage(), (IStatus)exception.getStatus());
            }
        });
        this.expandedFilelistComposite = new ExpandedFilelistComposite(container, 0);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.sourceStore, 0, 1024);
        data.left = new FormAttachment((Control)this.sourceStore, 0, 16384);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(70);
        data.height = 280;
        this.expandedFilelistComposite.setLayoutData(data);
        this.expandedFilelistComposite.setChecker(this);
        this.expandedFilelistComposite.setSelection(this.selection);
        this.destinationStore = new DirectoryChooserComposite(container, 0);
        FormData store = new FormData();
        store.top = new FormAttachment((Control)this.expandedFilelistComposite, 16, 1024);
        store.left = new FormAttachment((Control)this.expandedFilelistComposite, 0, 16384);
        store.right = new FormAttachment(100);
        this.destinationStore.setLayoutData(store);
        this.destinationStore.setTargetLabelText("Export to:");
        this.destinationStore.setInitialContainer(ExportDestinationPage.validContainerFromSelection(this.initialSelection));
        this.destinationStore.setChecker(this);
        this.restoreWidgetValues();
        this.okToComplete();
        this.setControl((Control)container);
        Logger.logInfo("Created " + this.getName());
    }
}

