/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.wizards;

import com.fold1.eulumdat.tools.wizards.EulumdatFileContentProvider;
import com.fold1.eulumdat.tools.wizards.WizardPageOkChecker;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ExpandedFilelistComposite
extends Composite {
    private static final int VOFFSET = 16;
    private final CheckboxTableViewer selectionViewer;
    private WizardPageOkChecker checker;
    private List<?> selection;

    public ExpandedFilelistComposite(Composite parent, int style) {
        super(parent, style);
        FormLayout form = new FormLayout();
        this.setLayout((Layout)form);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100, -50);
        data.height = 200;
        Table eulumdats = new Table((Composite)this, 2080);
        eulumdats.setLayoutData((Object)data);
        this.selectionViewer = new CheckboxTableViewer(eulumdats);
        this.selectionViewer.setContentProvider((IContentProvider)new EulumdatFileContentProvider());
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.selectionViewer.setInput(this.selection);
        this.setAll(true);
        this.selectionViewer.addCheckStateListener(event -> this.checker.okToComplete());
        Button all = new Button((Composite)this, 8);
        all.setText("Select All");
        all.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExpandedFilelistComposite.this.setAll(true);
                ExpandedFilelistComposite.this.checker.okToComplete();
            }
        });
        Button clear = new Button((Composite)this, 8);
        clear.setText("Deselect All");
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExpandedFilelistComposite.this.setAll(false);
                ExpandedFilelistComposite.this.checker.okToComplete();
            }
        });
        data = new FormData();
        data.top = new FormAttachment((Control)eulumdats, 16);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(100, -16);
        all.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)eulumdats, 16);
        data.left = new FormAttachment((Control)all);
        data.bottom = new FormAttachment(100, -16);
        clear.setLayoutData((Object)data);
    }

    public void setChecker(WizardPageOkChecker checker) {
        this.checker = checker;
    }

    public void setSelection(List<?> selection) {
        this.selection = selection;
        this.selectionViewer.setInput(selection);
        this.setAll(true);
    }

    protected void checkSubclass() {
    }

    protected final void setAll(boolean b) {
        this.selectionViewer.setAllChecked(b);
    }

    public Object[] getChecked() {
        return this.selectionViewer.getCheckedElements();
    }
}

