/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.wizards;

import com.fold1.eulumdat.tools.log.Logger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class EulumdatToolExportPage
extends WizardPage {
    protected List<Button> buttons = new ArrayList<Button>();
    protected Group group;

    public EulumdatToolExportPage(String pageName) {
        super(pageName);
    }

    public EulumdatToolExportPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout fill = new FormLayout();
        container.setLayout((Layout)fill);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        this.group = new Group(container, 16);
        this.group.setText("Choose " + this.getName());
        GridLayout layout = new GridLayout(5, true);
        this.group.setLayout((Layout)layout);
        this.group.setLayoutData((Object)data);
        this.setButtons();
        Button all = new Button(container, 8);
        all.setText("Select All");
        all.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                EulumdatToolExportPage.this.setAll(true);
                EulumdatToolExportPage.this.dialogChanged();
            }
        });
        Button clear = new Button(container, 8);
        clear.setText("Deselect All");
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                EulumdatToolExportPage.this.setAll(false);
                EulumdatToolExportPage.this.dialogChanged();
            }
        });
        Button deflt = new Button(container, 8);
        deflt.setText("Set Defaults");
        deflt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                EulumdatToolExportPage.this.setDefaults();
                EulumdatToolExportPage.this.dialogChanged();
            }
        });
        data = new FormData();
        data.top = new FormAttachment((Control)this.group);
        data.right = new FormAttachment(100);
        all.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.group);
        data.right = new FormAttachment((Control)all);
        clear.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.group);
        data.right = new FormAttachment((Control)clear);
        deflt.setLayoutData((Object)data);
        this.restoreWidgetValues();
        this.dialogChanged();
        this.setControl((Control)container);
        Logger.logInfo("Created " + this.getName());
    }

    public abstract void setButtons();

    public abstract void setDefaults();

    public void setGroupText(String string) {
        this.group.setText(string);
    }

    public void dialogChanged() {
        if (this.countSelected() == 0) {
            this.setErrorMessage("Choose at least one " + this.getName());
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public int countSelected() {
        int selected = 0;
        for (Button b : this.buttons) {
            if (!b.getSelection()) continue;
            ++selected;
        }
        return selected;
    }

    public void setAll(boolean flag) {
        for (Button b : this.buttons) {
            b.setSelection(flag);
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (settings = settings.addNewSection(this.getName())) != null) {
            for (Button b : this.buttons) {
                settings.put(b.getText(), b.getSelection());
            }
        }
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (settings = settings.getSection(this.getName())) != null) {
            for (Button b : this.buttons) {
                if (b == null) continue;
                b.setSelection(settings.getBoolean(b.getText()));
            }
            return;
        }
        this.setDefaults();
    }

    public int[] getButtons() {
        int[] selected = new int[this.countSelected() - 1];
        int j = 0;
        int i = 0;
        while (i < this.buttons.size() - 1) {
            Button b = this.buttons.get(i);
            if (b.getSelection()) {
                selected[j++] = i;
            }
            ++i;
        }
        return selected;
    }
}

