/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.wizards;

import com.fold1.e100lux.E100luxTool;
import com.fold1.eulumdat.tools.EulumdatToolsActivator;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.wizards.AbstractDestinationPage;
import com.fold1.eulumdat.tools.wizards.EulumdatToolExportPage;
import com.fold1.eulumdat.tools.wizards.ExportDestinationPage;
import com.fold1.eulumdat.tools.wizards.ReflectancePage;
import com.fold1.exceptions.ParserException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class E100LuxWizard
extends Wizard
implements IExportWizard {
    private static final String SETTINGS = "e100lux.xml";
    private EulumdatToolExportPage reflectancePage;
    private IStructuredSelection initialSelection;
    private AbstractDestinationPage destinationPage;
    private List<IFile> selected;
    private String destination;
    private int[] columns;
    private String settingsFilename;

    public E100LuxWizard() {
        this.setNeedsProgressMonitor(true);
        this.loadOrCreateDialogSettings();
    }

    public void addPages() {
        this.destinationPage = new ExportDestinationPage("E100Lux Export Destination", this.initialSelection);
        this.destinationPage.setSelection(this.selected);
        this.addPage((IWizardPage)this.destinationPage);
        this.reflectancePage = new ReflectancePage("Reflectance");
        this.addPage((IWizardPage)this.reflectancePage);
    }

    private void doFinish(IProgressMonitor monitor) throws CoreException {
        int todo = this.selected.size();
        monitor.beginTask("Processing " + todo + " files...", todo);
        E100luxTool tool = new E100luxTool(this.columns, this.destination);
        for (IFile f : this.selected) {
            block9: {
                IFile file;
                IPath location;
                IWorkspace workspace;
                try {
                    try {
                        File file2 = f.getLocation().toFile();
                        tool.process(tool.alloc(file2), file2);
                    }
                    catch (ParserException | IOException e) {
                        Logger.logError("Error converting to E100lux table from " + f.getName(), e);
                        workspace = ResourcesPlugin.getWorkspace();
                        location = Path.fromOSString((String)tool.getOutput());
                        file = workspace.getRoot().getFileForLocation(location);
                        if (file != null) {
                            monitor.setTaskName("Creating : " + tool.getShortOutput());
                            file.refreshLocal(0, null);
                        }
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    workspace = ResourcesPlugin.getWorkspace();
                    location = Path.fromOSString((String)tool.getOutput());
                    file = workspace.getRoot().getFileForLocation(location);
                    if (file != null) {
                        monitor.setTaskName("Creating : " + tool.getShortOutput());
                        file.refreshLocal(0, null);
                    }
                    throw throwable;
                }
                workspace = ResourcesPlugin.getWorkspace();
                location = Path.fromOSString((String)tool.getOutput());
                file = workspace.getRoot().getFileForLocation(location);
                if (file != null) {
                    monitor.setTaskName("Creating : " + tool.getShortOutput());
                    file.refreshLocal(0, null);
                }
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    public void init(IWorkbench wbench, IStructuredSelection selection) {
        this.initialSelection = selection;
        try {
            this.selected = Utils.expandSelection(selection.toList(), Utils.EULUMDAT);
        }
        catch (CoreException e) {
            Logger.logError("Failed to initialize from selection", e);
        }
    }

    private void loadOrCreateDialogSettings() {
        IPath path = EulumdatToolsActivator.getDefault().getStateLocation();
        this.settingsFilename = path.append(SETTINGS).toOSString();
        DialogSettings settings = new DialogSettings("E100lux");
        try {
            settings.load(this.settingsFilename);
        }
        catch (IOException e) {
            Logger.logError("Failed to restore E100lux wizard settings", e);
        }
        this.setDialogSettings((IDialogSettings)settings);
    }

    public boolean performFinish() {
        this.destinationPage.saveWidgetValues();
        this.reflectancePage.saveWidgetValues();
        this.columns = this.reflectancePage.getButtons();
        this.destination = this.destinationPage.getDestination();
        this.selected = this.destinationPage.getSelection();
        IRunnableWithProgress op = monitor -> {
            try {
                try {
                    this.doFinish(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }
}

