/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.wizards;

import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.wizards.AbstractChooserComposite;
import com.fold1.eulumdat.tools.wizards.ExpandedFilelistComposite;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractDestinationPage
extends WizardPage {
    private static final String CURRENT = "last_destination";
    private static final int MAXHIST = 5;
    private static final String HISTORYCOUNT = "count";
    private static final String HIST = "history";
    protected List<?> selection;
    protected AbstractChooserComposite destinationStore;
    protected AbstractChooserComposite sourceStore;
    protected ExpandedFilelistComposite expandedFilelistComposite;

    public AbstractDestinationPage(String pageName) {
        super(pageName);
    }

    public AbstractDestinationPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.destinationStore != null) {
            settings = settings.addNewSection(this.getName());
            settings.put(CURRENT, this.destinationStore.getTargetStorePathText());
            HashSet<String> history = new HashSet<String>();
            Collections.addAll(history, this.destinationStore.getItems());
            history.add(this.destinationStore.getTargetStorePathText());
            history.remove("");
            int count = Math.min(5, history.size());
            if (count > 0) {
                settings = settings.addNewSection(HIST);
                settings.put(HISTORYCOUNT, count);
                Iterator h = history.iterator();
                while (h.hasNext()) {
                    settings.put(HIST, (String)h.next());
                }
            }
        }
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (settings = settings.getSection(this.getName())) != null && settings.get(CURRENT) != null) {
            String name = settings.get(CURRENT);
            File fn = new File(name);
            if (fn.exists() && fn.canWrite()) {
                this.destinationStore.setTargetStorePathText(name);
            }
            if ((settings = settings.getSection(HIST)) != null) {
                int count = settings.getInt(HISTORYCOUNT);
                while (count-- > 0) {
                    name = settings.get(HIST);
                    fn = new File(name);
                    if (!fn.exists() || !fn.canWrite()) continue;
                    this.destinationStore.addItem(name);
                }
            }
        }
    }

    public String getDestination() {
        return this.destinationStore.getTargetStorePathText();
    }

    public void okToComplete() {
        String dest = this.destinationStore.getTargetStorePathText();
        File f = Utils.getAbsolutePathFile(dest);
        if (this.expandedFilelistComposite.getChecked().length == 0) {
            this.setErrorMessage("Select at least one file.");
            this.setPageComplete(false);
        } else if (dest.length() == 0) {
            this.setErrorMessage("Please select a directory for the output.");
            this.setPageComplete(false);
        } else if (!f.exists()) {
            this.setMessage("Directory \"" + dest + "\" does not exist and will be created.");
            this.setPageComplete(true);
        } else if (!f.canWrite()) {
            this.setErrorMessage("Cannot write to directory : " + dest + ".");
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public List<IFile> getSelection() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        Object[] objectArray = this.expandedFilelistComposite.getChecked();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            result.add((IFile)f);
            ++n2;
        }
        return result;
    }

    public void setSelection(List<IFile> selected) {
        this.selection = selected;
    }

    protected static IContainer validContainerFromSelection(IStructuredSelection ss) {
        if (ss == null) {
            return null;
        }
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IContainer) {
                return (IContainer)o;
            }
            if (o instanceof IResource) {
                IResource rsrc = (IResource)o;
                return rsrc.getParent();
            }
            ++n2;
        }
        return null;
    }

    protected Map<String, String> getOptions() {
        return Collections.emptyMap();
    }
}

