/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.wizards;

import com.fold1.eulumdat.tools.EulumdatToolsActivator;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.wizards.AbstractDestinationPage;
import com.fold1.eulumdat.tools.wizards.ImportDestinationPage;
import com.fold1.exceptions.ConversionException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractConversionWizard
extends Wizard {
    private static final String ERRORS_OCCURRED_DURING_IMPORT = "Errors occurred during import";
    private String destination;
    private AbstractDestinationPage destinationPage;
    protected Utils.Expander expander;
    private IStructuredSelection initialSelection;
    private List<IFile> selected;
    private Map<String, String> options;

    public AbstractConversionWizard() {
        this.setNeedsProgressMonitor(true);
        this.loadOrCreateDialogSettings();
    }

    public final void addPages() {
        this.destinationPage = new ImportDestinationPage("Save " + this.getDestinationLabel() + " in ", this.initialSelection, this.expander);
        this.destinationPage.setSelection(this.selected);
        this.addPage((IWizardPage)this.destinationPage);
    }

    protected abstract String convert(IFile var1, BufferedInputStream var2, Map<String, String> var3) throws ConversionException;

    private String createDestinationFile(IFile f) {
        File real = Utils.createIfNotExists(this.destination);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(real.getAbsolutePath().toString());
        stringBuilder.append("/");
        stringBuilder.append(f.getName().replace("." + f.getFileExtension(), ""));
        stringBuilder.append(this.getDestinationFileExtension());
        String out = stringBuilder.toString();
        return out;
    }

    /*
     * Unable to fully structure code
     */
    private void doFinish(IProgressMonitor monitor) throws CoreException {
        if (!RegistrationController.isOKToUse(true)) {
            return;
        }
        todo = this.selected.size();
        monitor.beginTask("Processing " + todo + " files...", todo);
        limit = 0;
        ms = null;
        for (IFile f : this.selected) {
            block19: {
                if (limit > 5 && !RegistrationController.isValidFullLicense(true)) break;
                out = null;
                try {
                    converted = this.readAndConvertSourceFile(f, this.options);
                    out = this.createDestinationFile(f);
                    if (out != null) {
                        this.writeDestinationFile(out, converted);
                    }
                }
                catch (ConversionException e) {
                    status = Logger.createStatus(4, 4, e.getMessage(), e.getCause());
                    if (ms == null) {
                        ms = Logger.getMultiStatus(101, "Errors occurred during import", null);
                    }
                    ms.add(status);
                    Logger.log(status);
                    ++limit;
                    if (out != null) {
                        workspace = ResourcesPlugin.getWorkspace();
                        location = Path.fromOSString((String)out);
                        file = workspace.getRoot().getFileForLocation(location);
                        if (file != null) {
                            monitor.setTaskName("Creating : " + out);
                            file.refreshLocal(0, null);
                        }
                    }
                    break block19;
                }
                catch (IOException e) {
                    try {
                        status = Logger.createStatus(4, 4, e.getMessage(), e);
                        if (ms == null) {
                            ms = Logger.getMultiStatus(101, "Errors occurred during import", null);
                        }
                        ms.add(status);
                        Logger.log(status);
                        ++limit;
                        ** if (out == null) goto lbl-1000
                    }
                    catch (Throwable var10_15) {
                        ++limit;
                        if (out != null) {
                            workspace = ResourcesPlugin.getWorkspace();
                            location = Path.fromOSString(out);
                            file = workspace.getRoot().getFileForLocation(location);
                            if (file != null) {
                                monitor.setTaskName("Creating : " + out);
                                file.refreshLocal(0, null);
                            }
                        }
                        throw var10_15;
                    }
lbl-1000:
                    // 1 sources

                    {
                        workspace = ResourcesPlugin.getWorkspace();
                        location = Path.fromOSString((String)out);
                        file = workspace.getRoot().getFileForLocation(location);
                        if (file != null) {
                            monitor.setTaskName("Creating : " + out);
                            file.refreshLocal(0, null);
                        }
                    }
lbl-1000:
                    // 4 sources

                    {
                        break block19;
                    }
                }
                ++limit;
                if (out == null) break block19;
                workspace = ResourcesPlugin.getWorkspace();
                location = Path.fromOSString((String)out);
                file = workspace.getRoot().getFileForLocation(location);
                if (file != null) {
                    monitor.setTaskName("Creating : " + out);
                    file.refreshLocal(0, null);
                }
            }
            monitor.worked(1);
        }
        monitor.done();
        if (ms != null) {
            throw new CoreException(ms);
        }
    }

    protected abstract String getDestinationFileExtension();

    protected abstract String getDestinationLabel();

    protected abstract Utils.Expander getExpander();

    protected abstract String getSettingsSectionName();

    protected abstract String getSourceLabel();

    public final void init(IWorkbench wb, IStructuredSelection selection) {
        this.initialSelection = selection;
        try {
            this.selected = Utils.expandSelection(selection.toList(), this.getExpander());
        }
        catch (CoreException e) {
            Logger.logError("Failed to initialize from selection", e);
        }
    }

    private void loadOrCreateDialogSettings() {
        IDialogSettings settings = EulumdatToolsActivator.getDefault().getDialogSettings();
        this.setDialogSettings(settings);
    }

    public final boolean performFinish() {
        this.destinationPage.saveWidgetValues();
        this.destination = this.destinationPage.getDestination();
        this.selected = this.destinationPage.getSelection();
        this.options = this.destinationPage.getOptions();
        IRunnableWithProgress op = monitor -> {
            try {
                try {
                    this.doFinish(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException e) {
            CoreException realException = (CoreException)e.getTargetException();
            ErrorDialog.openError((Shell)this.getShell(), (String)ERRORS_OCCURRED_DURING_IMPORT, (String)realException.getMessage(), (IStatus)realException.getStatus());
            return false;
        }
        return true;
    }

    private String readAndConvertSourceFile(IFile f, Map<String, String> options1) throws ConversionException, IOException, CoreException {
        String converted = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedInputStream inputStream = new BufferedInputStream(f.getContents());){
            converted = this.convert(f, inputStream, options1);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return converted;
    }

    private void writeDestinationFile(String out, String string) throws FileNotFoundException, UnsupportedEncodingException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter output = new PrintWriter(out, ResourcesPlugin.getEncoding());){
            output.print(string);
            output.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Logger.logInfo("Converted " + this.getSourceLabel() + " to : " + out);
    }
}

