/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.views;

import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.properties.EulumdatProperty;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.views.AbstractProductPropertyElement;
import com.fold1.eulumdat.tools.views.ProductPropertyCategory;
import com.fold1.eulumdat.tools.views.ProductPropertyLamp;
import com.fold1.eulumdat.tools.views.ProductPropertySet;
import com.fold1.eulumdat.tools.views.ProductPropertyValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ProductPropertiesViewContentProvider
implements ITreeContentProvider {
    private static final int MAXITEMS = 2000;
    private boolean showLamps;
    private boolean showSymmetry;
    private boolean showType;
    private List<IFile> contents;
    private final boolean showFlux;
    private boolean showPhotometry = true;

    public ProductPropertiesViewContentProvider(boolean showLamps, boolean showSymmetry, boolean showType) {
        this.showLamps = showLamps;
        this.showSymmetry = showSymmetry;
        this.showType = showType;
        this.showFlux = true;
    }

    public ProductPropertiesViewContentProvider() {
        this.showLamps = true;
        this.showSymmetry = true;
        this.showType = true;
        this.showFlux = true;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
        if (this.contents != null) {
            this.contents.clear();
        }
    }

    public Object[] getElements(Object parent) {
        ProductPropertyCategory properties = new ProductPropertyCategory(null);
        if (parent instanceof List) {
            this.contents = (List)parent;
            Iterator<IFile> each = this.contents.iterator();
            int count = 0;
            while (each.hasNext() && count < 2000) {
                IResource res = (IResource)each.next();
                ProductPropertySet property = this.getPropsFromResource(properties, res);
                if (property != null) {
                    properties.addEntry(property);
                }
                ++count;
            }
        }
        return properties.getEntries().toArray();
    }

    private ProductPropertySet getPropsFromResource(ProductPropertyCategory properties, IResource res) {
        EulumdatProperty property;
        try {
            property = (EulumdatProperty)res.getSessionProperty(EulumdatProperty.EULUMDAT_PROPKEY);
        }
        catch (CoreException e) {
            Logger.logError("Error reading properties from " + res.getName(), e);
            return null;
        }
        if (property != null) {
            StringBuilder sb;
            StringBuilder sb1 = new StringBuilder();
            sb1.append(property.getId());
            sb1.append(" ");
            sb1.append(property.getProductname());
            String description = "".equals(property.getId()) ? property.getProductname() : sb1.toString();
            ProductPropertySet product = new ProductPropertySet(properties, description, res);
            if (this.showFlux) {
                sb = new StringBuilder();
                sb.append("Flux: ");
                sb.append(property.getFluxDistribution());
                product.addEntry(new ProductPropertyValue(product, sb.toString()));
            }
            if (this.showLamps) {
                int i = 0;
                while (i < property.getLampset().length) {
                    String lamp = property.getLampset()[i];
                    product.addEntry(new ProductPropertyLamp(product, lamp, i));
                    ++i;
                }
            }
            if (this.showPhotometry) {
                sb = new StringBuilder();
                sb.append("Photometry: ");
                sb.append(property.getPhotometryType());
                product.addEntry(new ProductPropertyValue(product, sb.toString()));
            }
            if (this.showSymmetry) {
                sb = new StringBuilder();
                sb.append("Symmetry/Gamma: ");
                sb.append(property.getSymmetry());
                sb.append(property.getGamma());
                product.addEntry(new ProductPropertyValue(product, sb.toString()));
            }
            if (this.showType) {
                sb = new StringBuilder();
                sb.append("Type: ");
                sb.append(property.getType());
                product.addEntry(new ProductPropertyValue(product, sb.toString()));
            }
            return product;
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = null;
        if (parentElement instanceof IFile) {
            ArrayList<AbstractProductPropertyElement> items = new ArrayList<AbstractProductPropertyElement>();
            IFile file = (IFile)parentElement;
            ProductPropertySet properties = this.getPropsFromResource(null, (IResource)file);
            if (properties == null) {
                properties = new ProductPropertySet(null, "No properties defined yet", (IResource)file);
            }
            items.add(properties);
            List<AbstractProductPropertyElement> entries = properties.getEntries();
            if (entries != null) {
                items.addAll(entries);
            }
            result = items.toArray();
            return result;
        }
        if (parentElement instanceof ProductPropertyCategory) {
            ProductPropertyCategory category = (ProductPropertyCategory)parentElement;
            result = category.getEntries().toArray();
            return result;
        }
        return AbstractProductPropertyElement.NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (element instanceof AbstractProductPropertyElement) {
            AbstractProductPropertyElement ppElement = (AbstractProductPropertyElement)element;
            return ppElement.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IFile && Utils.isEulumdat((IResource)((IFile)element))) {
            Object property = null;
            try {
                property = ((IFile)element).getSessionProperty(EulumdatProperty.EULUMDAT_PROPKEY);
            }
            catch (CoreException e) {
                Logger.logError("Error reading properties from " + ((IFile)element).getName(), e);
            }
            return property != null;
        }
        if (element instanceof ProductPropertyCategory) {
            ProductPropertyCategory category = (ProductPropertyCategory)element;
            return category.getParent() != null;
        }
        return false;
    }

    public void setShowLamps(boolean showLamps) {
        this.showLamps = showLamps;
    }

    public void setShowSymmetry(boolean showSymmetry) {
        this.showSymmetry = showSymmetry;
    }

    public void setShowType(boolean showType) {
        this.showType = showType;
    }

    public void setShowPhotometry(boolean showPhotometry) {
        this.showPhotometry = showPhotometry;
    }
}

