/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.views;

import com.fold1.eulumdat.tools.EulumdatToolsActivator;
import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatEditor;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.utils.Rebuilder;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.views.AbstractProductPropertyElement;
import com.fold1.eulumdat.tools.views.EulumdatPatternFilter;
import com.fold1.eulumdat.tools.views.ProductPropertiesViewContentProvider;
import com.fold1.eulumdat.tools.views.ProductPropertiesViewLabelProvider;
import com.fold1.eulumdat.tools.views.ProductPropertyLamp;
import com.fold1.eulumdat.tools.views.ProductPropertySet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class ProductPropertiesView
extends ViewPart {
    public static final String VIEW_ID = "com.fold1.eulumdat.tools.views.ProductPropertiesView";
    public static final String PACKAGE_EXPLORER = "org.eclipse.jdt.ui.PackageExplorer";
    public static final String NAVIGATOR_VIEW = "org.eclipse.ui.navigator.CommonNavigator";
    private static final String PRODUCT_PROPERTIES = "product";
    private static final String FALSE = "FALSE";
    private static final String TRUE = "TRUE";
    private static final String SHOWTYPE_KEY = "showtype";
    private static final String SHOWSYM_KEY = "showsym";
    private static final String SHOWLAMP_KEY = "showlamp";
    private List<IFile> contents = null;
    private TreeViewer viewer;
    private TreeColumn keyColumn;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action toggleLampsAction;
    private Action toggleSymmetryAction;
    private Action toggleTypeAction;
    private Action doubleClickAction;
    boolean showLamps = true;
    boolean showSymmetry = true;
    boolean showType = true;
    private ProductPropertiesViewContentProvider contentProvider;

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout form = new FormLayout();
        container.setLayout((Layout)form);
        FormData list = new FormData();
        list.top = new FormAttachment(0);
        list.left = new FormAttachment(0);
        list.right = new FormAttachment(100);
        list.bottom = new FormAttachment(100);
        FilteredTree treeview = new FilteredTree(container, 774, (PatternFilter)new EulumdatPatternFilter(), true, true);
        treeview.setLayoutData((Object)list);
        this.viewer = treeview.getViewer();
        this.contentProvider = new ProductPropertiesViewContentProvider(this.showLamps, this.showSymmetry, this.showType);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProductPropertiesViewLabelProvider());
        this.viewer.setComparator((ViewerComparator)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        this.keyColumn = new TreeColumn(tree, 0);
        this.keyColumn.setText("Selected Product Name");
        this.keyColumn.setWidth(300);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.initListener();
        this.setContentsAsync(this.contents);
    }

    private void initListener() {
        IWorkbenchPage page = this.getSite().getPage();
        IStructuredSelection selection = (IStructuredSelection)page.getSelection("org.eclipse.ui.navigator.ProjectExplorer");
        this.contents = ProductPropertiesView.selectionToContents((ISelection)selection);
        ISelectionListener sl = (part, sel) -> {
            if (!Rebuilder.hasRunOnce("com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature")) {
                return;
            }
            String id = part.getSite().getId();
            if ("org.eclipse.ui.navigator.ProjectExplorer".equals(id) || PACKAGE_EXPLORER.equals(id) || NAVIGATOR_VIEW.equals(id)) {
                if (sel instanceof IStructuredSelection) {
                    StructuredSelection ss = (StructuredSelection)sel;
                    Object[] objectArray = ss.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selected = objectArray[n2];
                        if (selected instanceof IResource) {
                            IProject project = ((IResource)selected).getProject();
                            try {
                                if (!project.isOpen() || !project.hasNature("com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature")) {
                                    this.setContentsAsync(null);
                                    return;
                                }
                            }
                            catch (CoreException e) {
                                Logger.logError("Error reading from project " + project.getName(), e);
                            }
                        }
                        ++n2;
                    }
                    this.contents = ProductPropertiesView.selectionToContents(sel);
                    this.setContentsAsync(this.contents);
                }
            } else if (Platform.inDevelopmentMode()) {
                Platform.inDevelopmentMode();
            }
        };
        page.addSelectionListener(sl);
    }

    private void setContentsAsync(List<IFile> contents) {
        Display.getDefault().asyncExec(() -> {
            this.viewer.getTree().setVisible(false);
            this.viewer.setInput((Object)contents);
            this.viewer.refresh();
            this.viewer.expandToLevel(1);
            this.viewer.getTree().setVisible(true);
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.fillContextMenu(manager));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.toggleSymmetryAction);
        manager.add((IAction)this.toggleTypeAction);
        manager.add((IAction)this.toggleLampsAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.toggleSymmetryAction);
        manager.add((IAction)this.toggleTypeAction);
        manager.add((IAction)this.toggleLampsAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.toggleSymmetryAction);
        manager.add((IAction)this.toggleTypeAction);
        manager.add((IAction)this.toggleLampsAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
    }

    private void makeActions() {
        this.expandAllAction = new Action(){

            public void run() {
                ProductPropertiesView.this.viewer.expandAll();
            }
        };
        this.expandAllAction.setText("Expand All");
        this.expandAllAction.setToolTipText("Expand all Product Properties");
        this.expandAllAction.setImageDescriptor(EulumdatToolsActivator.getImageDescriptor("icons/expandall.png"));
        this.collapseAllAction = new Action(){

            public void run() {
                ProductPropertiesView.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setText("Collapse All");
        this.collapseAllAction.setToolTipText("Collapse All Product properties");
        this.collapseAllAction.setImageDescriptor(EulumdatToolsActivator.getImageDescriptor("icons/collapseall.png"));
        this.toggleTypeAction = new Action(){

            public void run() {
                ProductPropertiesView.this.showType = !ProductPropertiesView.this.showType;
                ProductPropertiesView.this.toggleTypeAction.setChecked(ProductPropertiesView.this.showType);
                ProductPropertiesView.this.contentProvider.setShowType(ProductPropertiesView.this.showType);
                ProductPropertiesView.this.viewer.refresh();
                ProductPropertiesView.this.viewer.expandAll();
            }
        };
        this.toggleTypeAction.setText("Show Source Type");
        this.toggleTypeAction.setChecked(this.showType);
        this.toggleTypeAction.setToolTipText("POINT_VERTICAL_SYM, LINEAR, POINT_OTHER_SYM");
        this.toggleTypeAction.setImageDescriptor(EulumdatToolsActivator.getImageDescriptor("icons/type.png"));
        this.toggleLampsAction = new Action(){

            public void run() {
                ProductPropertiesView.this.showLamps = !ProductPropertiesView.this.showLamps;
                ProductPropertiesView.this.toggleLampsAction.setChecked(ProductPropertiesView.this.showLamps);
                ProductPropertiesView.this.contentProvider.setShowLamps(ProductPropertiesView.this.showLamps);
                ProductPropertiesView.this.viewer.refresh();
                ProductPropertiesView.this.viewer.expandAll();
            }
        };
        this.toggleLampsAction.setText("Show Lamps");
        this.toggleLampsAction.setChecked(this.showLamps);
        this.toggleLampsAction.setImageDescriptor(EulumdatToolsActivator.getImageDescriptor("icons/lamps.png"));
        this.toggleSymmetryAction = new Action(){

            public void run() {
                ProductPropertiesView.this.showSymmetry = !ProductPropertiesView.this.showSymmetry;
                ProductPropertiesView.this.toggleSymmetryAction.setChecked(ProductPropertiesView.this.showSymmetry);
                ProductPropertiesView.this.contentProvider.setShowSymmetry(ProductPropertiesView.this.showSymmetry);
                ProductPropertiesView.this.viewer.refresh();
                ProductPropertiesView.this.viewer.expandAll();
            }
        };
        this.toggleSymmetryAction.setText("Show Symmetry");
        this.toggleSymmetryAction.setChecked(this.showSymmetry);
        this.toggleSymmetryAction.setToolTipText("ROTATION_INT, C0-180, C90_270, QUAD_INT, NONE_INT");
        this.toggleSymmetryAction.setImageDescriptor(EulumdatToolsActivator.getImageDescriptor("icons/symmetry.png"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ProductPropertiesView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ProductPropertySet match = ProductPropertiesView.findSet(obj);
                if (match == null) {
                    ProductPropertiesView.this.showMessage("Cannot resolve " + obj.toString());
                    return;
                }
                IResource parent = match.getFile();
                if (parent == null) {
                    ProductPropertiesView.this.showMessage("Cannot open " + obj.toString());
                    return;
                }
                IFile file = (IFile)parent;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    if (part instanceof EulumdatEditor && obj instanceof ProductPropertyLamp) {
                        ProductPropertyLamp productPropertyLamp = (ProductPropertyLamp)obj;
                    }
                }
                catch (PartInitException e) {
                    Logger.logError("Error opening editor for " + file.getName(), e);
                    return;
                }
            }
        };
    }

    protected static ProductPropertySet findSet(Object obj) {
        if (obj instanceof AbstractProductPropertyElement) {
            AbstractProductPropertyElement current = (AbstractProductPropertyElement)obj;
            while (current != null) {
                if (current instanceof ProductPropertySet) {
                    return (ProductPropertySet)current;
                }
                current = current.getParent();
            }
        }
        return null;
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(event -> this.doubleClickAction.run());
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Luminous Distribution", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            IMemento[] mems;
            IMemento[] iMementoArray = mems = memento.getChildren(PRODUCT_PROPERTIES);
            int n = mems.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento mem = iMementoArray[n2];
                if (mem.getString(SHOWTYPE_KEY) != null && FALSE.equals(mem.getString(SHOWTYPE_KEY))) {
                    this.showType = false;
                }
                if (mem.getString(SHOWSYM_KEY) != null && FALSE.equals(mem.getString(SHOWSYM_KEY))) {
                    this.showSymmetry = false;
                }
                if (mem.getString(SHOWLAMP_KEY) != null && FALSE.equals(mem.getString(SHOWLAMP_KEY))) {
                    this.showLamps = false;
                }
                ++n2;
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        IMemento mem = memento.createChild(PRODUCT_PROPERTIES);
        mem.putString(SHOWTYPE_KEY, this.showType ? TRUE : FALSE);
        mem.putString(SHOWSYM_KEY, this.showSymmetry ? TRUE : FALSE);
        mem.putString(SHOWLAMP_KEY, this.showLamps ? TRUE : FALSE);
    }

    private static List<IFile> selectionToContents(ISelection sel) {
        List<IFile> result = null;
        if (sel != null) {
            try {
                result = Utils.expandSelection(((IStructuredSelection)sel).toArray(), Utils.EULUMDAT);
            }
            catch (CoreException e) {
                Logger.logError("Error expanding selection in Product Properties", e);
            }
        }
        return result;
    }

    private static class NameSorter
    extends ViewerComparator {
        private NameSorter() {
        }

        public int compare(Viewer viewer1, Object e1, Object e2) {
            return super.compare(viewer1, e1, e2);
        }
    }
}

