/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.utils;

import com.fold1.data.ICGamma;
import com.fold1.data.Symmetry;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.util.NumberOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class Utils {
    private static final String[] EULUMDATEXTENSIONS = new String[]{".ldt", ".uld", ".elx"};
    private static final String[] IESEXTENSIONS = new String[]{".ies"};
    public static final Expander EULUMDAT = resource -> Utils.isEulumdat(resource);
    public static final Expander IES = resource -> Utils.isIES(resource);

    private Utils() {
    }

    public static boolean isEulumdat(String name) {
        String lcname = name.toLowerCase();
        String[] stringArray = EULUMDATEXTENSIONS;
        int n = EULUMDATEXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (lcname.endsWith(extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isEulumdat(IResource resource) {
        if (resource.exists() && resource instanceof IFile) {
            IFile file = (IFile)resource;
            return Utils.isEulumdat(file.getName());
        }
        return false;
    }

    public static boolean isIES(String name) {
        String lcname = name.toLowerCase();
        String[] stringArray = IESEXTENSIONS;
        int n = IESEXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (lcname.endsWith(extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isIES(IResource resource) {
        if (resource.exists() && resource instanceof IFile) {
            IFile file = (IFile)resource;
            return Utils.isIES(file.getName());
        }
        return false;
    }

    public static List<IFile> expandSelection(List<IResource> foldedList, Expander expander) throws CoreException {
        ArrayList<IFile> results = new ArrayList<IFile>();
        for (IResource rsrc : foldedList) {
            if (!(rsrc instanceof IResource) || !rsrc.isAccessible()) continue;
            if (rsrc instanceof IFile) {
                if (!expander.isMatch((IResource)((IFile)rsrc))) continue;
                results.add((IFile)rsrc);
                continue;
            }
            if (rsrc instanceof IProject) {
                IProject p = (IProject)rsrc;
                results.addAll(Utils.expandSelection(p.members(), expander));
                continue;
            }
            if (!(rsrc instanceof IFolder)) continue;
            IFolder f = (IFolder)rsrc;
            results.addAll(Utils.expandSelection(f.members(), expander));
        }
        return results;
    }

    public static List<IFile> expandSelection(Object[] array, Expander expander) throws CoreException {
        ArrayList<IFile> results = new ArrayList<IFile>();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object rsrc = objectArray[n2];
            if (rsrc instanceof IResource && ((IResource)rsrc).isAccessible()) {
                if (rsrc instanceof IFile) {
                    if (expander.isMatch((IResource)((IFile)rsrc))) {
                        results.add((IFile)rsrc);
                    }
                } else if (rsrc instanceof IProject) {
                    IProject p = (IProject)rsrc;
                    results.addAll(Utils.expandSelection(p.members(), expander));
                } else if (rsrc instanceof IFolder) {
                    IFolder f = (IFolder)rsrc;
                    results.addAll(Utils.expandSelection(f.members(), expander));
                }
            }
            ++n2;
        }
        return results;
    }

    public static List<IFile> expandSelection(String path, Expander expander) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        String rootpath = root.getRawLocation().toString();
        if (path.contains(rootpath)) {
            String partial = path.substring(rootpath.length());
            IResource container = root.findMember(partial);
            if (container != null) {
                ArrayList<IFile> results = new ArrayList<IFile>();
                results.addAll(Utils.expandSelection(new IResource[]{container}, expander));
                return results;
            }
        } else {
            Shell shell = Display.getDefault().getActiveShell();
            MessageDialog.openInformation((Shell)shell, (String)"Sorry, but not yet implemented", (String)"Importing and converting files from outside the workspace is not yet supported.");
        }
        return Collections.emptyList();
    }

    public static File createIfNotExists(String destination) {
        File f = Utils.getAbsolutePathFile(destination);
        if (!f.exists()) {
            boolean result = f.mkdirs();
            if (result) {
                Logger.logInfo("Created: " + f.getAbsolutePath().toString());
            } else {
                Logger.logError("Failed to create: " + f.getAbsolutePath().toString(), null);
            }
        }
        return f;
    }

    public static File getAbsolutePathFile(String destination) {
        File f = new File(destination);
        if (!f.exists()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IPath relative = new Path(destination).makeRelativeTo((IPath)new Path(root.getLocation().toOSString()));
            IResource res = root.findMember(relative);
            f = res.getLocation().toFile();
        }
        return f;
    }

    public static ArrayList<String> createCPlaneLabels(ICGamma cgamma) {
        ArrayList<String> cLabels = new ArrayList<String>();
        int offset = 0;
        if (Symmetry.C_90_270.equals((Object)cgamma.getIsym())) {
            offset = 3 * cgamma.getNoCPlanes() / 4;
        }
        int c = 0;
        while (c < cgamma.getNoCPlaneValues()) {
            int index = (c + offset) % cgamma.getNoCPlanes();
            cLabels.add(Utils.createCAngleLabel(cgamma, index));
            ++c;
        }
        return cLabels;
    }

    public static String createCAngleLabel(ICGamma cgamma, int c) {
        double angleC = cgamma.getAngleC(c);
        return "C" + NumberOutput.digits((double)angleC, (int)1);
    }

    public static interface Expander {
        public boolean isMatch(IResource var1);
    }
}

