/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.utils;

import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.utils.BuilderUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class Rebuilder
extends Job {
    private static final QualifiedName BUILDER_KEY = new QualifiedName("pars", "builder");
    private static final QualifiedName PROJECT_KEY = new QualifiedName("pars", "project");
    private static Map<String, Long> runs = new HashMap<String, Long>();
    private final String builder;
    private final String nature;
    protected boolean parallelBuilds = true;
    private IProject projectToRebuild;

    public static boolean hasRunOnce(String natureID) {
        try {
            String builderName = BuilderUtils.findBuilder(natureID);
            Long count = runs.get(builderName);
            if (count != null && count > 0L) {
                return true;
            }
        }
        catch (CoreException e) {
            Logger.logError("Cannot determine whether has run once", e);
        }
        return false;
    }

    private static void incrementRuns(String builderName) {
        Long n = runs.get(builderName);
        if (n == null) {
            n = 0L;
        }
        runs.put(builderName, n + 1L);
    }

    public Rebuilder(String name, String nature, String builder) {
        super(name);
        this.nature = nature;
        this.builder = builder;
    }

    public Rebuilder(String name, String nature, String builder, IProject project) {
        this(name, nature, builder);
        this.projectToRebuild = project;
        this.setRule((ISchedulingRule)project);
    }

    public boolean belongsTo(Object family) {
        if (family.equals("com.fold1.eulumdat.tools")) {
            return true;
        }
        return super.belongsTo(family);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            IResourceVisitor visitor = resource -> {
                if (resource instanceof IProject) {
                    IProject project = (IProject)resource;
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    if (!project.isAccessible()) {
                        return false;
                    }
                    if (!project.hasNature(this.nature)) {
                        return false;
                    }
                    if (this.projectToRebuild != null && !project.equals((Object)this.projectToRebuild)) {
                        return false;
                    }
                    if (this.parallelBuilds) {
                        StartupWorkspaceBuildJob buildJob = new StartupWorkspaceBuildJob("Checking  " + project.getName() + " with " + this.builder);
                        buildJob.setProperty(BUILDER_KEY, this.builder);
                        buildJob.setProperty(PROJECT_KEY, project);
                        buildJob.schedule();
                    } else {
                        project.build(6, this.builder, null, monitor);
                    }
                    return false;
                }
                return true;
            };
            workspace.getRoot().accept(visitor);
            Rebuilder.incrementRuns(this.builder);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            Logger.logError("Error occured during rebuild", e);
            return new Status(4, "com.fold1.eulumdat.tools", 0, "CoreException", (Throwable)e);
        }
    }

    private final class StartupWorkspaceBuildJob
    extends WorkspaceJob {
        private StartupWorkspaceBuildJob(String name) {
            super(name);
        }

        public boolean belongsTo(Object family) {
            if (family.equals("com.fold1.eulumdat.tools")) {
                return true;
            }
            return super.belongsTo(family);
        }

        public IStatus runInWorkspace(IProgressMonitor mon) throws CoreException {
            try {
                IProject p = (IProject)this.getProperty(PROJECT_KEY);
                String b = (String)this.getProperty(BUILDER_KEY);
                p.build(6, b, null, mon);
            }
            catch (CoreException e) {
                IStatus status = Logger.createStatus(4, 0, "Build Problem", e);
                Logger.log(status);
                return status;
            }
            return Status.OK_STATUS;
        }
    }
}

