/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.utils;

import com.fold1.eulumdat.tools.log.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;

public final class BuilderUtils {
    private static final String ID = "id";
    private static final String BUILDER = "builder";
    private static final String ORG_ECLIPSE_CORE_RESOURCES_NATURES = "org.eclipse.core.resources.natures";

    private BuilderUtils() {
    }

    public static String findBuilder(String natureId) throws CoreException {
        IExtension extension;
        String builder;
        block5: {
            builder = null;
            extension = Platform.getExtensionRegistry().getExtension(ORG_ECLIPSE_CORE_RESOURCES_NATURES, natureId);
            if (extension != null) break block5;
            return null;
        }
        try {
            IConfigurationElement[] configElements;
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                if (BUILDER.equals(config.getName())) {
                    builder = config.getAttribute(ID);
                    break;
                }
                ++n2;
            }
        }
        catch (InvalidRegistryObjectException e) {
            IStatus status = Logger.createStatus(4, 0, "Cannot determine builder for " + natureId, e);
            Logger.log(status);
            throw new CoreException(status);
        }
        return builder;
    }

    public static void deleteMarkers(IResource res, String markerType) {
        try {
            res.deleteMarkers(markerType, true, 2);
        }
        catch (CoreException ce) {
            Logger.logError("Problem deleting markers", ce);
        }
    }
}

