/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.properties;

import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.properties.EulumdatProperty;
import com.fold1.eulumdat.tools.utils.Utils;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class FileTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IFile) {
            IFile file = (IFile)receiver;
            if (Utils.isIES((IResource)file)) {
                if ("isIes".equals(property)) {
                    return true;
                }
            } else if (Utils.isEulumdat((IResource)file)) {
                if ("isEulumdat".equals(property)) {
                    return true;
                }
                if ("fluxDistribution".equals(property)) {
                    try {
                        EulumdatProperty fproperty = (EulumdatProperty)file.getSessionProperty(EulumdatProperty.EULUMDAT_PROPKEY);
                        return fproperty != null && expectedValue.equals(fproperty.getFluxDistribution());
                    }
                    catch (CoreException e) {
                        Logger.logError("Unable to decorate with Properties", e);
                    }
                }
            }
        }
        return false;
    }
}

