/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.properties;

import com.fold1.data.Eulumdat2;
import com.fold1.data.EulumdatFactory;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.parser.ParserFactory;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.exceptions.ParserException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

@Immutable
public final class EulumdatProperty
implements IPropertySource {
    public static final String TRADITIONAL = "traditional";
    public static final String ABSOLUTE = "absolute photometry";
    private static final double CIE_SEMIINDIRECT_THRESHOLD = 10.0;
    private static final double CIE_DIRECTINDIRECT_THRESHOLD = 40.0;
    private static final double CIE_SEMIDIRECT_THRESHOLD = 60.0;
    private static final double CIE_DIRECT_THRESHOLD = 90.0;
    public static final String INDIRECT = "indirect";
    public static final String SEMI_INDIRECT = "semi-indirect";
    public static final String DIRECT_INDIRECT = "direct-indirect";
    public static final String SEMI_DIRECT = "semi-direct";
    public static final String DIRECT = "direct";
    public static final String FIXED = " FG";
    public static final String VARIABLE = " VG";
    public static final QualifiedName EULUMDAT_PROPKEY = new QualifiedName("com.fold1.eulumdat.tools", "property");
    private static final String TYPE_ID = "eulumdat.type";
    private static final TextPropertyDescriptor TYPE_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor((Object)"eulumdat.type", "Type");
    private static final String SYM_ID = "eulumdat.sym";
    private static final TextPropertyDescriptor SYM_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor((Object)"eulumdat.sym", "Symmetry");
    private static final String GAMMA_ID = "eulumdat.gamma";
    private static final TextPropertyDescriptor GAMMA_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor((Object)"eulumdat.gamma", "Gamma");
    private static final String ID_ID = "eulumdat.id";
    private static final TextPropertyDescriptor ID_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor((Object)"eulumdat.id", "Product Code");
    private static final String NAME_ID = "eulumdat.name";
    private static final TextPropertyDescriptor NAME_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor((Object)"eulumdat.name", "Product Name");
    private static final String LAMPS_ID = "eulumdat.lamps";
    private static final TextPropertyDescriptor LAMPS_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor((Object)"eulumdat.lamps", "Lamp Sets");
    private static final Object FLUX_ID = "eulumdat.flux";
    private static final TextPropertyDescriptor FLUX_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor(FLUX_ID, "Flux Distribution");
    private static final Object PHOTO_ID = "eulumdat.photometry";
    private static final TextPropertyDescriptor PHOTO_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor(PHOTO_ID, "Photometry Type");
    private static final String PRODUCT_CATEGORY = "Product";
    private static final IPropertyDescriptor[] DESCRIPTORS;
    private final String id;
    private final String productname;
    private final String[] lampset;
    private final String symmetry;
    private final String gamma;
    private final String type;
    private final String fluxDistribution;
    private final String photometryType;

    static {
        ID_PROPERTY_DESCRIPTOR.setCategory(PRODUCT_CATEGORY);
        NAME_PROPERTY_DESCRIPTOR.setCategory(PRODUCT_CATEGORY);
        LAMPS_PROPERTY_DESCRIPTOR.setCategory(PRODUCT_CATEGORY);
        SYM_PROPERTY_DESCRIPTOR.setCategory(PRODUCT_CATEGORY);
        GAMMA_PROPERTY_DESCRIPTOR.setCategory(PRODUCT_CATEGORY);
        TYPE_PROPERTY_DESCRIPTOR.setCategory(PRODUCT_CATEGORY);
        FLUX_PROPERTY_DESCRIPTOR.setCategory(PRODUCT_CATEGORY);
        PHOTO_PROPERTY_DESCRIPTOR.setCategory(PRODUCT_CATEGORY);
        DESCRIPTORS = new IPropertyDescriptor[]{ID_PROPERTY_DESCRIPTOR, NAME_PROPERTY_DESCRIPTOR, LAMPS_PROPERTY_DESCRIPTOR, SYM_PROPERTY_DESCRIPTOR, GAMMA_PROPERTY_DESCRIPTOR, TYPE_PROPERTY_DESCRIPTOR, FLUX_PROPERTY_DESCRIPTOR, PHOTO_PROPERTY_DESCRIPTOR};
    }

    public static EulumdatProperty createProperty(IFile f) throws CoreException {
        Eulumdat2 eulumdat = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream stream = new BufferedInputStream(f.getContents());){
                boolean strict = ParserFactory.isStrict();
                ParserFactory.setStrict((boolean)false);
                eulumdat = EulumdatFactory.eulumdatFromInputStream((InputStream)stream, (String)f.getName());
                ParserFactory.setStrict((boolean)strict);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ParserException | IOException e) {
            IStatus status = Logger.createStatus(4, 0, e.getMessage(), e);
            throw new CoreException(status);
        }
        if (eulumdat != null) {
            return new EulumdatProperty((IEulumdatRO)eulumdat);
        }
        return null;
    }

    private EulumdatProperty() {
        this.photometryType = null;
        this.type = null;
        this.symmetry = null;
        this.gamma = null;
        this.fluxDistribution = null;
        this.productname = null;
        this.id = null;
        this.lampset = null;
    }

    public EulumdatProperty(IEulumdatRO eulumdat) {
        this.id = eulumdat.getProductCode().intern();
        this.productname = eulumdat.getProductName().intern();
        this.lampset = new String[eulumdat.getNumberOfLampSets()];
        int i = 0;
        while (i < eulumdat.getNumberOfLampSets()) {
            this.lampset[i] = eulumdat.getLampSet(i).getType().intern();
            ++i;
        }
        this.symmetry = eulumdat.getIsym().toString();
        this.gamma = eulumdat.getDg() == 0.0 ? VARIABLE : FIXED;
        this.type = eulumdat.getItyp().toString();
        this.photometryType = eulumdat.isAbsolute() ? ABSOLUTE : TRADITIONAL;
        double percentage = eulumdat.getDownwardFluxPercentage();
        this.fluxDistribution = percentage > 90.0 ? DIRECT : (percentage > 60.0 ? SEMI_DIRECT : (percentage > 40.0 ? DIRECT_INDIRECT : (percentage > 10.0 ? SEMI_INDIRECT : INDIRECT)));
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(DESCRIPTORS, DESCRIPTORS.length);
    }

    public Object getPropertyValue(Object identifier) {
        if (ID_ID.equals(identifier)) {
            return this.id;
        }
        if (NAME_ID.equals(identifier)) {
            return this.getProductname();
        }
        if (LAMPS_ID.equals(identifier)) {
            return this.getLampset();
        }
        if (SYM_ID.equals(identifier)) {
            return this.getSymmetry();
        }
        if (GAMMA_ID.equals(identifier)) {
            return this.getGamma();
        }
        if (TYPE_ID.equals(identifier)) {
            return this.getType();
        }
        if (FLUX_ID.equals(identifier)) {
            return this.getFluxDistribution();
        }
        if (PHOTO_ID.equals(identifier)) {
            return this.getPhotometryType();
        }
        return null;
    }

    public boolean isPropertySet(Object identifier) {
        return false;
    }

    public void resetPropertyValue(Object identfier) {
    }

    public void setPropertyValue(Object identifier, Object value) {
    }

    public String[] getProperties() {
        String[] result = new String[7 + this.lampset.length];
        result[0] = this.id;
        result[1] = this.productname;
        result[2] = this.symmetry;
        result[3] = this.type;
        result[4] = this.gamma;
        result[5] = this.fluxDistribution;
        result[6] = this.getPhotometryType();
        System.arraycopy(this.lampset, 0, result, 7, this.lampset.length);
        return result;
    }

    public String[] getLampset() {
        return Arrays.copyOf(this.lampset, this.lampset.length);
    }

    public String getProductname() {
        return this.productname;
    }

    public String getSymmetry() {
        return this.symmetry;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getGamma() {
        return this.gamma;
    }

    public String getFluxDistribution() {
        return this.fluxDistribution;
    }

    public String getPhotometryType() {
        return this.photometryType;
    }

    public int hashCode() {
        return Objects.hash(this.fluxDistribution, this.gamma, this.id, Arrays.hashCode(this.lampset), this.photometryType, this.productname, this.symmetry, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EulumdatProperty other = (EulumdatProperty)obj;
        if (!Objects.equals(this.fluxDistribution, other.fluxDistribution)) {
            return false;
        }
        if (!Objects.equals(this.gamma, other.gamma)) {
            return false;
        }
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        if (!Arrays.equals(this.lampset, other.lampset)) {
            return false;
        }
        if (!Objects.equals(this.photometryType, other.photometryType)) {
            return false;
        }
        if (!Objects.equals(this.productname, other.productname)) {
            return false;
        }
        if (!Objects.equals(this.symmetry, other.symmetry)) {
            return false;
        }
        return Objects.equals(this.type, other.type);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EulumdatProperty [id=");
        builder.append(this.id);
        builder.append(", productname=");
        builder.append(this.productname);
        builder.append(", lampset=");
        builder.append(Arrays.toString(this.lampset));
        builder.append(", symmetry=");
        builder.append(this.symmetry);
        builder.append(", gamma=");
        builder.append(this.gamma);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", fluxDistribution=");
        builder.append(this.fluxDistribution);
        builder.append(", photometryType=");
        builder.append(this.photometryType);
        builder.append("]");
        return builder.toString();
    }
}

