/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.preferences;

import com.bdaum.overlaypages.FieldEditorOverlayPage;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.preferences.EulumdatToolsPreferences;
import com.fold1.eulumdat.tools.preferences.PatternFieldEditor;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import com.fold1.eulumdat.tools.utils.BuilderUtils;
import com.fold1.eulumdat.tools.utils.Rebuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ValidatorPreferencePage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.fold1.eulumdat.tools.preferences.ValidatorPreferencePage";
    private BooleanFieldEditor checkDffPresent;
    private BooleanFieldEditor checkDffValues;
    private BooleanFieldEditor checkDownFlux;
    private BooleanFieldEditor checkLor;
    private BooleanFieldEditor checkNadirEditor;
    private BooleanFieldEditor checkPowerNotZero;
    private BooleanFieldEditor checkProductCodeNotEmpty;
    private BooleanFieldEditor filenameLength;
    private BooleanFieldEditor manufacturerFlag;
    private BooleanFieldEditor dateFlag;
    private BooleanFieldEditor protocolFlag;
    private BooleanFieldEditor productcodeFlag;
    private PatternFieldEditor manufacturerRE;
    private PatternFieldEditor dateRE;
    private PatternFieldEditor protocolRE;
    private PatternFieldEditor productcodeRE;

    public ValidatorPreferencePage() {
        super(1);
        this.setPreferenceStore(EulumdatToolsPreferences.getStore());
        this.setDescription("Use the options below to add/remove LDT validation rules");
    }

    protected void checkState() {
        super.checkState();
        if (this.manufacturerFlag.getBooleanValue() && !this.manufacturerRE.isValid()) {
            this.setErrorMessage(this.manufacturerRE.getErrorMessage());
            this.setValid(false);
            return;
        }
        if (this.manufacturerFlag.getBooleanValue() && this.manufacturerRE.getStringValue().equals("")) {
            this.setErrorMessage("Please specify pattern for manufacturer");
            this.setValid(false);
            return;
        }
        if (this.protocolFlag.getBooleanValue() && !this.protocolRE.isValid()) {
            this.setErrorMessage(this.protocolRE.getErrorMessage());
            this.setValid(false);
            return;
        }
        if (this.protocolFlag.getBooleanValue() && this.protocolRE.getStringValue().equals("")) {
            this.setErrorMessage("Please specify pattern for protocol");
            this.setValid(false);
            return;
        }
        if (this.productcodeFlag.getBooleanValue() && !this.productcodeRE.isValid()) {
            this.setErrorMessage(this.productcodeRE.getErrorMessage());
            this.setValid(false);
            return;
        }
        if (this.productcodeFlag.getBooleanValue() && this.productcodeRE.getStringValue().equals("")) {
            this.setErrorMessage("Please specify pattern for productcode");
            this.setValid(false);
            return;
        }
        if (this.dateFlag.getBooleanValue() && !this.dateRE.isValid()) {
            this.setErrorMessage(this.dateRE.getErrorMessage());
            this.setValid(false);
            return;
        }
        if (this.dateFlag.getBooleanValue() && this.dateRE.getStringValue().equals("")) {
            this.setErrorMessage("Please specify pattern for date");
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("StrictEulumdatParser", "Use strict parser for EULUMDAT files", this.getFieldEditorParent()));
        this.addField((FieldEditor)new RadioGroupFieldEditor("EulumdatVersion", "Use EULUMDAT version field length ", 3, (String[][])new String[][]{{"&No limit", "none"}, {"Eulumdat/&1 (24)", "eulumdat1"}, {"Eulumdat/&2 (78)", "eulumdat2"}}, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("LampTypeKnown", "Check for known &lamptype in 'converter.lamps'", this.getFieldEditorParent()));
        this.checkPowerNotZero = new BooleanFieldEditor("PowerNotZero", "Check whether power for designated lamps is non-&zero", this.getFieldEditorParent());
        this.addField((FieldEditor)this.checkPowerNotZero);
        this.checkProductCodeNotEmpty = new BooleanFieldEditor("ProductCodeNotEmpty", "Check for filled in &product code", this.getFieldEditorParent());
        this.addField((FieldEditor)this.checkProductCodeNotEmpty);
        this.filenameLength = new BooleanFieldEditor("FilenameMatch", "Check for filename match", this.getFieldEditorParent());
        this.addField((FieldEditor)this.filenameLength);
        this.filenameLength = new BooleanFieldEditor("FilenameLength", "Check for filename length (8 chars)", this.getFieldEditorParent());
        this.addField((FieldEditor)this.filenameLength);
        this.manufacturerFlag = new BooleanFieldEditor("MatchManufacturer", "Check for correct manufacturer (line 1)", this.getFieldEditorParent());
        this.addField((FieldEditor)this.manufacturerFlag);
        this.manufacturerRE = new PatternFieldEditor("MatchManufacturerRE", "Manufacturer must match:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.manufacturerRE);
        this.manufacturerRE.setErrorMessage("Error in manufacturer pattern");
        this.protocolFlag = new BooleanFieldEditor("MatchProtocol", "Check for correct protocol (line 8)", this.getFieldEditorParent());
        this.addField((FieldEditor)this.protocolFlag);
        this.protocolRE = new PatternFieldEditor("MatchProtocolRE", "Protocol must match:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.protocolRE);
        this.protocolRE.setErrorMessage("Error in protocol pattern");
        this.productcodeFlag = new BooleanFieldEditor("MatchProductCode", "Check for correct product code (line 10)", this.getFieldEditorParent());
        this.addField((FieldEditor)this.productcodeFlag);
        this.productcodeRE = new PatternFieldEditor("MatchProductCodeRE", "Productcode must match:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.productcodeRE);
        this.protocolRE.setErrorMessage("Error in product code pattern");
        this.dateFlag = new BooleanFieldEditor("MatchDate", "Check for correct date (line 12)", this.getFieldEditorParent());
        this.addField((FieldEditor)this.dateFlag);
        this.dateRE = new PatternFieldEditor("MatchDateRE", "Date must match:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.dateRE);
        this.dateRE.setErrorMessage("Error in date pattern");
        this.checkNadirEditor = new BooleanFieldEditor("CheckNadir", "Check consistent values at gamma 0 (nadir) and gamma 180 (zenith)", this.getFieldEditorParent());
        this.addField((FieldEditor)this.checkNadirEditor);
        this.checkLor = new BooleanFieldEditor("CalcValuesLOR", "Check value of calculated LOR", this.getFieldEditorParent());
        this.addField((FieldEditor)this.checkLor);
        this.checkDownFlux = new BooleanFieldEditor("CalcValuesDownFlux", "Check value of calculated Down Flux", this.getFieldEditorParent());
        this.addField((FieldEditor)this.checkDownFlux);
        this.checkDffPresent = new BooleanFieldEditor("CheckDFFPresent", "Check presence of Direct Flux Factors (EXPERIMENTAL)", this.getFieldEditorParent());
        this.addField((FieldEditor)this.checkDffPresent);
        this.checkDffValues = new BooleanFieldEditor("CalcValuesDFF", "Check values of calculated Direct Flux Factors (EXPERIMENTAL)", this.getFieldEditorParent());
        this.addField((FieldEditor)this.checkDffValues);
        this.updateFieldEditorsHook(true);
    }

    @Override
    protected String getPageId() {
        return ID;
    }

    public void init(IWorkbench workbench) {
        this.setDescription("Change operation of the EULUMDAT Validator");
    }

    @Override
    public boolean performOk() {
        String builder;
        this.checkState();
        if (!this.isValid()) {
            return false;
        }
        Shell shell = this.getShell();
        boolean rebuild = MessageDialog.openQuestion((Shell)shell, (String)"Changes require rebuild", (String)"Your changes require a full rebuild. Perform this rebuild now?");
        try {
            builder = BuilderUtils.findBuilder("com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature");
        }
        catch (CoreException e) {
            Logger.logError("Error finding builder for com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature", e);
            return false;
        }
        if (!rebuild) {
            return false;
        }
        EulumdatToolsPreferences.getInstance().tellPreferenceChangeListeners("MatchDateRE");
        EulumdatToolsPreferences.getInstance().tellPreferenceChangeListeners("MatchManufacturerRE");
        EulumdatToolsPreferences.getInstance().tellPreferenceChangeListeners("MatchProtocolRE");
        EulumdatToolsPreferences.getInstance().tellPreferenceChangeListeners("MatchProductCodeRE");
        EulumdatToolsPreferences.getInstance().tellPreferenceChangeListeners("EulumdatVersion");
        Rebuilder rebuilder = null;
        if (this.isPropertyPage()) {
            IProject project = (IProject)this.getElement();
            rebuilder = new Rebuilder("Preferences Change Project Rebuild", "com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature", builder, project);
        } else {
            rebuilder = new Rebuilder("Preferences Change Workspace Rebuild", "com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature", builder);
        }
        rebuilder.schedule(20L);
        return super.performOk();
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value") && (event.getSource() == this.manufacturerFlag || event.getSource() == this.dateFlag || event.getSource() == this.productcodeFlag || event.getSource() == this.protocolFlag)) {
            this.checkState();
        }
    }

    @Override
    public void updateFieldEditorsHook(boolean enabled) {
        if (!RegistrationController.isOKToUse(false)) {
            this.checkProductCodeNotEmpty.setEnabled(false, this.getFieldEditorParent());
            this.productcodeFlag.setEnabled(false, this.getFieldEditorParent());
            this.productcodeRE.setEnabled(false, this.getFieldEditorParent());
            this.filenameLength.setEnabled(false, this.getFieldEditorParent());
            this.checkPowerNotZero.setEnabled(false, this.getFieldEditorParent());
            this.manufacturerFlag.setEnabled(false, this.getFieldEditorParent());
            this.manufacturerRE.setEnabled(false, this.getFieldEditorParent());
            this.dateFlag.setEnabled(false, this.getFieldEditorParent());
            this.dateRE.setEnabled(false, this.getFieldEditorParent());
            this.checkNadirEditor.setEnabled(false, this.getFieldEditorParent());
            this.checkLor.setEnabled(false, this.getFieldEditorParent());
            this.checkDownFlux.setEnabled(false, this.getFieldEditorParent());
            this.checkDffPresent.setEnabled(false, this.getFieldEditorParent());
            this.checkDffValues.setEnabled(false, this.getFieldEditorParent());
            this.protocolFlag.setEnabled(false, this.getFieldEditorParent());
            this.protocolRE.setEnabled(false, this.getFieldEditorParent());
        }
    }
}

