/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.preferences;

import com.fold1.eulumdat.tools.preferences.EulumdatToolsPreferences;
import com.fold1.eulumdat.tools.preferences.LicenseChecker;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RegistrationPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor licenseCodeFieldEditor;
    private final String licenseCode;
    private final boolean trialOver;
    private StringFieldEditor testlabNameFieldEditor;
    private StringFieldEditor nameFieldEditor;
    private StringFieldEditor emailFieldEditor;

    public RegistrationPreferencePage() {
        super(1);
        this.setPreferenceStore(EulumdatToolsPreferences.getStore());
        this.licenseCode = this.getPreferenceStore().getDefaultString("UserKey");
        this.trialOver = RegistrationController.isTrialPeriodOver(true);
        this.setDescription("Visit http://www.fold1.com/eulumdattools/ to register and then fill in the fields below and press Register");
    }

    protected void createFieldEditors() {
        this.nameFieldEditor = new StringFieldEditor("UserName", "Name:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.nameFieldEditor);
        this.emailFieldEditor = new StringFieldEditor("UserEmail", "E-mail:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.emailFieldEditor);
        this.licenseCodeFieldEditor = new StringFieldEditor("UserKey", "License Code:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.licenseCodeFieldEditor);
        this.testlabNameFieldEditor = new StringFieldEditor("TestlabName", "Name of Testlab:", this.getFieldEditorParent());
        this.testlabNameFieldEditor.setStringValue("EulumdatTools");
        this.addField((FieldEditor)this.testlabNameFieldEditor);
        this.testlabNameFieldEditor.setEnabled(RegistrationController.isValidFullLicense(false), this.getFieldEditorParent());
    }

    private boolean validateEntries() {
        String name = this.nameFieldEditor.getStringValue();
        String email = this.emailFieldEditor.getStringValue();
        String nlicenseCode = this.licenseCodeFieldEditor.getStringValue();
        return RegistrationController.validateCode(name, email, nlicenseCode);
    }

    private boolean emptyEntries() {
        String name = this.nameFieldEditor.getStringValue();
        String email = this.emailFieldEditor.getStringValue();
        String code = this.licenseCodeFieldEditor.getStringValue();
        return code.isBlank() && name.isBlank() && email.isBlank();
    }

    public boolean performOk() {
        if (this.emptyEntries()) {
            return true;
        }
        boolean validateEntries = this.validateEntries();
        if (!validateEntries) {
            this.setErrorMessage("Name, email or license code not entered correctly!");
            return false;
        }
        String newLicenseCode = this.licenseCodeFieldEditor.getStringValue();
        this.testlabNameFieldEditor.setEnabled(validateEntries && newLicenseCode.startsWith("FULL"), this.getFieldEditorParent());
        boolean checkedLicense = LicenseChecker.getInstance().check(newLicenseCode, true);
        if (this.trialOver) {
            if (newLicenseCode.startsWith("FULL")) {
                if (checkedLicense) {
                    this.setErrorMessage("Unable to verify license at this moment.\nPlease validate later.");
                }
                return super.performOk();
            }
            if (newLicenseCode.startsWith("EVAL") && !this.licenseCode.equals(newLicenseCode)) {
                this.setErrorMessage("This product was evaluated already.\nPlease purchase FULL license.");
                return false;
            }
        } else {
            if (checkedLicense) {
                this.setErrorMessage("Unable to verify license at this moment.\nPlease validate later.");
            }
            return super.performOk();
        }
        return false;
    }

    public void init(IWorkbench workbench) {
    }
}

