/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.preferences;

import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.preferences.EulumdatToolsPreferences;
import com.fold1.eulumdat.tools.preferences.LicenseChecker;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

@ThreadSafe
public final class RegistrationController {
    private static final String THIS_VERSION_OF_EULUMDAT_TOOLS_IS_NOT_REGISTERED = "This version of Eulumdat Tools is not registered.\n";
    private static final String THE_REGISTERED_LICENSE_PERIOD_IS_OVER = "The registered license period is over.\n";
    private static final String FUNCTIONALITY_WILL_BE_LIMITED_UNTIL_REGISTRATION = "Functionality will be limited until registration ";
    private static final String IS_COMPLETED_PLEASE_COMPLETE_YOUR_REGISTRATION_ON = "is completed.\nPlease complete your registration on ";
    private static final String FUNCTIONALITY_WILL_BE_LIMITED_FROM_NOW_ON = "Functionality will be limited from now on.\n";
    private static final String PLEASE_RENEW_YOUR_LICENSE_TO_RESTORE_TO_FULL_FUNCTIONALITY_ON = "Please renew your license to restore to full functionality on ";
    private static final String HTTP_WWW_FOLD1_COM_EULUMDATTOOLS = "http://www.fold1.com/eulumdattools/.\n\n";
    private static final String GO_TO_REGISTRATION_PAGE_NOW = "Go to registration page now?";
    private static final String PREFERENCES_REGISTRATION = "com.fold1.eulumdat.tools.preferences.registration";
    private static final String EMPTY_STRING = "";
    private static final LocalDate EXPIRY = LocalDate.of(2026, 12, 31);
    private static final String ENTER_LICENSE_CODE = "Enter License Code";
    private static final String GOTO_REGISTRATION = "Go to Registration";
    private static final int EVALUATION = 1;
    private static final int STANDARD = 2;
    private static int productLevel;
    private static boolean registered;
    private static boolean running;

    static {
        running = false;
    }

    private RegistrationController() {
    }

    public static String encode(byte[] in) {
        byte ch = 0;
        int i = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        while (i < in.length) {
            if (i % 4 == 0) {
                out.append("-");
            }
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            ++i;
        }
        String rslt = new String(out);
        return rslt;
    }

    public static int getProductLevel() {
        return productLevel;
    }

    public static boolean isBuildExpired(boolean showDialog) {
        LocalDate now = LocalDate.now();
        boolean expired = now.isAfter(EXPIRY);
        if (expired && showDialog && !running) {
            Display.getDefault().asyncExec(() -> {
                running = true;
                Shell shell = Display.getCurrent().getActiveShell();
                MessageDialog.openWarning((Shell)shell, (String)"Eulumdat Tools Build Version Expired!!", (String)"This version of Eulumdat Tools has expired and updates may be available.\nPlease check for updates Using \"Help/Check for Updates\".");
                running = false;
            });
        }
        return expired;
    }

    public static boolean phoneHome() {
        IPreferenceStore store = EulumdatToolsPreferences.getStore();
        String code = store.getString("UserKey");
        return !code.equals(EMPTY_STRING) && LicenseChecker.getInstance().check(code, true);
    }

    public static boolean isLicenseExpired(boolean showDialog) {
        IPreferenceStore store = EulumdatToolsPreferences.getStore();
        String code = store.getString("UserKey");
        LicenseChecker licenseChecker = LicenseChecker.getInstance();
        boolean expired = licenseChecker.check(code, false);
        if (expired && showDialog && !running) {
            String dialogTitle = "Eulumdat Tools License Expired!!";
            String dialogMessage = "The registered license period is over.\nFunctionality will be limited from now on.\nPlease renew your license to restore to full functionality on http://www.fold1.com/eulumdattools/.\n\nGo to registration page now?";
            RegistrationController.doAskForRegistrationDialog("Eulumdat Tools License Expired!!", "The registered license period is over.\nFunctionality will be limited from now on.\nPlease renew your license to restore to full functionality on http://www.fold1.com/eulumdattools/.\n\nGo to registration page now?");
        }
        return expired;
    }

    private static void doAskForRegistrationDialog(String dialogTitle, String dialogMessage) {
        Display.getDefault().asyncExec(() -> {
            running = true;
            Shell shell = Display.getCurrent().getActiveShell();
            MessageDialog dg = new MessageDialog(shell, dialogTitle, null, dialogMessage, 3, new String[]{GOTO_REGISTRATION, IDialogConstants.NO_LABEL, ENTER_LICENSE_CODE}, 0);
            switch (dg.open()) {
                case 0: {
                    Program.launch((String)"http://www.fold1.com/eulumdattools/installation.php#evaluation");
                    break;
                }
                default: {
                    break;
                }
                case 2: {
                    RegistrationController.showRegistrationPreferencePage(shell);
                }
            }
            running = false;
        });
    }

    public static boolean isNotRegistered(boolean showDialog) {
        IPreferenceStore store = EulumdatToolsPreferences.getStore();
        String name = store.getString("UserName");
        String email = store.getString("UserEmail");
        String code = store.getString("UserKey");
        if (code.startsWith("EVAL")) {
            productLevel = 1;
        }
        if (code.startsWith("FULL")) {
            productLevel = 2;
        }
        boolean bl = registered = !name.equals(EMPTY_STRING) && !email.equals(EMPTY_STRING) && !code.equals(EMPTY_STRING) && RegistrationController.validateCode(name, email, code);
        if (!registered && showDialog && !running) {
            String dialogTitle = "Eulumdat Tools Not Registered!!";
            String dialogMessage = "This version of Eulumdat Tools is not registered.\nFunctionality will be limited until registration is completed.\nPlease complete your registration on http://www.fold1.com/eulumdattools/.\n\nGo to registration page now?";
            RegistrationController.doAskForRegistrationDialog("Eulumdat Tools Not Registered!!", "This version of Eulumdat Tools is not registered.\nFunctionality will be limited until registration is completed.\nPlease complete your registration on http://www.fold1.com/eulumdattools/.\n\nGo to registration page now?");
        }
        return !registered;
    }

    public static boolean isOKToUse(boolean showDialog) {
        if (RegistrationController.isNotRegistered(showDialog)) {
            return false;
        }
        if (RegistrationController.getProductLevel() == 1 && RegistrationController.isLicenseExpired(showDialog) && RegistrationController.isTrialPeriodOver(showDialog)) {
            return false;
        }
        if (RegistrationController.getProductLevel() == 2 && RegistrationController.isLicenseExpired(showDialog)) {
            return false;
        }
        if (RegistrationController.isBuildExpired(showDialog)) {
            return true;
        }
        return true;
    }

    public static boolean isTrialPeriodOver(boolean showDialog) {
        LocalDate trialPeriodOverDate;
        LocalDate now = LocalDate.now();
        IPreferenceStore store = EulumdatToolsPreferences.getStore();
        String trialPeriodOverDateString = store.getString("Installdate");
        if (trialPeriodOverDateString.equals(EMPTY_STRING)) {
            LocalDate expiry = LocalDate.now().plusMonths(1L);
            trialPeriodOverDateString = expiry.toString();
            store.setValue("Installdate", trialPeriodOverDateString);
        }
        try {
            trialPeriodOverDate = LocalDate.parse(trialPeriodOverDateString);
        }
        catch (DateTimeParseException e) {
            Logger.logError("Cannot parse install date", e);
            store.setValue("Installdate", EMPTY_STRING);
            return true;
        }
        boolean expired = now.isAfter(trialPeriodOverDate);
        if (expired && showDialog && !running) {
            String dialogTitle = "Eulumdat Tools Expired!!";
            String dialogMessage = "The 30-day trial period is over.\nFunctionality will be limited from now on.\nPlease purchase a license to get access to full functionality on http://www.fold1.com/eulumdattools/.\n\nGo to registration page now?";
            RegistrationController.doAskForRegistrationDialog("Eulumdat Tools Expired!!", "The 30-day trial period is over.\nFunctionality will be limited from now on.\nPlease purchase a license to get access to full functionality on http://www.fold1.com/eulumdattools/.\n\nGo to registration page now?");
        }
        return expired;
    }

    public static boolean isValidFullLicense(boolean showDialog) {
        if (RegistrationController.isNotRegistered(showDialog)) {
            return false;
        }
        if (RegistrationController.getProductLevel() == 1) {
            if (showDialog && !running) {
                String dialogTitle = "You only have an Eulumdat Tools EVALUATION License";
                String dialogMessage = "An EVAL license has reduced functionality compared to a FULL (paid) license.\n\nConversions and other operations are limited to max 5 operations.\nPlease purchase a license to get access to full functionality on http://www.fold1.com/eulumdattools/.\n\nGo to registration page now?";
                RegistrationController.doAskForRegistrationDialog("You only have an Eulumdat Tools EVALUATION License", "An EVAL license has reduced functionality compared to a FULL (paid) license.\n\nConversions and other operations are limited to max 5 operations.\nPlease purchase a license to get access to full functionality on http://www.fold1.com/eulumdattools/.\n\nGo to registration page now?");
            }
            return false;
        }
        if (RegistrationController.getProductLevel() == 2 && RegistrationController.isLicenseExpired(showDialog)) {
            return false;
        }
        if (RegistrationController.isBuildExpired(showDialog)) {
            return true;
        }
        return true;
    }

    public static synchronized void showRegistrationPreferencePage(Shell shell) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        PreferenceManager preferenceManager = workbench.getPreferenceManager();
        if (preferenceManager != null) {
            PreferenceDialog dialog = new PreferenceDialog(workbench.getActiveWorkbenchWindow().getShell(), preferenceManager);
            dialog.setSelectedNode(PREFERENCES_REGISTRATION);
            dialog.create();
            dialog.open();
        }
    }

    public static boolean validateCode(String name, String email, String code) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            StringBuilder keyBuilder = new StringBuilder();
            keyBuilder.append(name);
            keyBuilder.append(email);
            keyBuilder.append(code.substring(0, 4));
            String key = keyBuilder.toString();
            byte[] input = key.getBytes("UTF-8");
            md.update(input);
            byte[] raw = md.digest();
            String hash = RegistrationController.encode(raw);
            return code.substring(4).equals(hash);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.logError("Problem with registration validation algorithm", e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.logError("Problem with registration validation encoding", e);
        }
        return false;
    }

    public static String getUserAgent() {
        return LicenseChecker.getUserAgent();
    }
}

