/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.preferences;

import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.preferences.EulumdatToolsPreferences;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;

final class LicenseChecker {
    private static final String FOLD1_HOME_CHECK = "https://www.fold1.com/eulumdattools/check.php?check=";
    private static final int HTTP_OK = 200;
    private static final long ONEWEEK = 604800000L;
    private final String etVersion;
    private static String osVersion = Platform.getOS();
    private static String archVersion = Platform.getOSArch();
    Map<String, Boolean> checks;
    private static LicenseChecker instance;

    private LicenseChecker(Bundle b) {
        this.etVersion = (String)b.getHeaders().get("Bundle-Version");
        this.checks = new HashMap<String, Boolean>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createInstance(Bundle b) {
        LicenseChecker r = instance;
        if (r != null) return;
        Class<LicenseChecker> clazz = LicenseChecker.class;
        synchronized (LicenseChecker.class) {
            r = instance;
            if (r != null) return;
            instance = r = new LicenseChecker(b);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static LicenseChecker getInstance() {
        assert (instance != null) : "LicenseChecker is not initialized";
        return instance;
    }

    public boolean check(String code) {
        return this.check(code, false);
    }

    public boolean check(String code, boolean force) {
        if (!force && this.checks.containsKey(code)) {
            return this.checks.get(code);
        }
        boolean result = !LicenseChecker.checkHome(code);
        this.checks.put(code, result);
        return result;
    }

    private static synchronized boolean checkHome(String code) {
        boolean result = false;
        StringBuffer sb = new StringBuffer();
        sb.append(FOLD1_HOME_CHECK);
        sb.append(code);
        try {
            URL home = new URL(sb.toString());
            URLConnection conn = home.openConnection();
            conn.setRequestProperty("User-Agent", LicenseChecker.getUserAgent());
            conn.connect();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection h = (HttpURLConnection)conn;
                int responseCode = h.getResponseCode();
                if (200 == responseCode) {
                    IPreferenceStore store = EulumdatToolsPreferences.getStore();
                    LocalDateTime expiry = LocalDateTime.ofEpochSecond(h.getExpiration() / 1000L, (int)(h.getExpiration() % 1000L), ZoneOffset.UTC);
                    String licensePeriodOverDateString = expiry.toLocalDate().toString();
                    store.setValue("Installdate", licensePeriodOverDateString);
                    String lastCheckedDateString = LocalDate.now().toString();
                    store.setValue("LastChecked", lastCheckedDateString);
                    Logger.logInfo("Succesfully verified license, expiry date is : " + String.valueOf(expiry));
                    result = true;
                } else {
                    Logger.logInfo("Could not verify license, code returned: " + responseCode);
                }
            }
        }
        catch (IOException e) {
            Logger.logError("Error checking license", e);
        }
        IPreferenceStore store = EulumdatToolsPreferences.getStore();
        String licenseCode = store.getString("UserKey");
        if (!result && code.equals(licenseCode)) {
            Logger.logInfo("Could not verify license, no connection, trying cached");
            String lastChecked = store.getString("LastChecked");
            String licensePeriodChecked = store.getString("Installdate");
            if (lastChecked != null && licensePeriodChecked != null) {
                LocalDate now = LocalDate.now();
                try {
                    LocalDate checked = LocalDate.parse(lastChecked);
                    LocalDate expires = LocalDate.parse(licensePeriodChecked);
                    if (now.isBefore(expires) && now.minusDays(604800000L).isBefore(checked)) {
                        result = true;
                    }
                }
                catch (DateTimeParseException e) {
                    Logger.logError("Could not verify license in cache : ", e);
                }
            }
        }
        return result;
    }

    public static String getUserAgent() {
        assert (instance != null) : "LicenseChecker is not initialized";
        return "EulumdatTools/v" + LicenseChecker.instance.etVersion + "/" + osVersion + "/" + archVersion;
    }
}

