/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.lamps;

import com.fold1.eulumdat.tools.lamps.ILampVerifier;
import com.fold1.eulumdat.tools.lamps.LampManager;
import com.fold1.eulumdat.tools.log.Logger;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

@ThreadSafe
public final class LampManagerPool
implements IResourceChangeListener {
    private static final String CONVERSIONFILENAME = "converter.lamps";
    private static LampManagerPool instance;
    private final Map<IProject, LampManager> managers = new HashMap<IProject, LampManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LampManagerPool getInstance() {
        LampManagerPool r = instance;
        if (r != null) return instance;
        Class<LampManagerPool> clazz = LampManagerPool.class;
        synchronized (LampManagerPool.class) {
            r = instance;
            if (r != null) return instance;
            instance = r = new LampManagerPool();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private LampManagerPool() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 3);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        for (Map.Entry<IProject, LampManager> entry : this.managers.entrySet()) {
            LampManagerPool.forgetManager(entry.getKey());
        }
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILampVerifier getManager(IProject project) {
        try {
            if (!project.isAccessible() || !project.hasNature("com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature")) {
                return null;
            }
        }
        catch (CoreException e) {
            Logger.logError("Problem creating LampManager for " + project.getName(), e);
        }
        Class<LampManagerPool> clazz = LampManagerPool.class;
        synchronized (LampManagerPool.class) {
            if (LampManagerPool.getInstance().managers.containsKey(project)) {
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return LampManagerPool.getInstance().managers.get(project);
            }
            LampManager newhire = new LampManager(project);
            LampManagerPool.getInstance().managers.put(project, newhire);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return newhire;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void forgetManager(IProject project) {
        if (!LampManagerPool.getInstance().managers.containsKey(project)) return;
        Class<LampManagerPool> clazz = LampManagerPool.class;
        synchronized (LampManagerPool.class) {
            LampManager manager = (LampManager)LampManagerPool.getManager(project);
            if (manager != null) {
                manager.dispose();
            }
            LampManagerPool.getInstance().managers.remove(project);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Logger.logInfo("Removed LampManager for : " + project.getName());
            return;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            ConverterLampsChangedVisitor lamspChangedVisitor = new ConverterLampsChangedVisitor(CONVERSIONFILENAME);
            try {
                delta.accept((IResourceDeltaVisitor)lamspChangedVisitor);
            }
            catch (CoreException e) {
                Logger.logError("Problem looking for 'converter.lamps' :" + e.getMessage(), e);
                return;
            }
        }
    }

    private static class ConverterLampsChangedVisitor
    implements IResourceDeltaVisitor {
        private final String match;

        public ConverterLampsChangedVisitor(String match) {
            this.match = match;
        }

        public boolean visit(IResourceDelta resource) {
            IFile file;
            if (resource != null && resource.getResource() instanceof IFile && (file = (IFile)resource.getResource()).getName().equals(this.match)) {
                switch (resource.getKind()) {
                    case 1: {
                        LampManagerPool.forgetManager(file.getProject());
                        break;
                    }
                    case 2: {
                        LampManagerPool.forgetManager(file.getProject());
                        break;
                    }
                    case 4: {
                        LampManagerPool.forgetManager(file.getProject());
                        break;
                    }
                    default: {
                        Logger.logInfo("Change event [" + resource.getKind() + "] for " + String.valueOf(file.getProject()));
                    }
                }
                return false;
            }
            return true;
        }
    }
}

