/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.lamps;

import com.fold1.eulumdat.tools.lamps.ILampVerifier;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.util.EncodingUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

@ThreadSafe
public final class LampManager
implements ILampVerifier {
    private static final String CONVERTER_LAMPS = "/converter.lamps";
    private Map<String, String> synonyms;
    private SortedSet<String> legalLamps;
    private IProject project;
    private long timestamp;

    public LampManager(IProject project) {
        this.project = project;
        this.init();
    }

    private LampManager() {
    }

    public void init() {
        IFile conversions = this.project.getFile(CONVERTER_LAMPS);
        if (conversions.exists()) {
            this.legalLamps = new TreeSet<String>();
            InputStreamReader input = null;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(conversions.getContents());){
                    String charset = EncodingUtils.guessCharEncoding((BufferedInputStream)bufferedInputStream, (String)conversions.getName());
                    input = new InputStreamReader((InputStream)bufferedInputStream, charset);
                    this.synonyms = LampManager.readLampConversions(input, this.legalLamps);
                    this.timestamp = conversions.getModificationStamp();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                Logger.logError("Problem reading 'converter.lamps' in project " + this.project.getName(), e);
            }
        }
    }

    @Override
    public boolean isInited() {
        return this.synonyms != null && this.legalLamps != null;
    }

    public static Map<String, String> readLampConversions(InputStreamReader input, SortedSet<String> legal) {
        BufferedReader in = new BufferedReader(input);
        return LampManager.readLampConversions(in, legal);
    }

    public static Map<String, String> readLampConversions(BufferedReader in, SortedSet<String> legal) {
        HashMap<String, String> synonyms = new HashMap<String, String>();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                String from = LampManager.fromPart(line).intern();
                String to = LampManager.toPart(line).intern();
                synonyms.put(from, to);
                if (legal != null && !to.equalsIgnoreCase("skip")) {
                    legal.add(to);
                }
                if (to.length() != 0) continue;
                Logger.logError("'converter.lamps' contains empty replacement:" + from, new Exception("Lamp '" + from + "' has replacement with length == 0"));
            }
        }
        catch (FileNotFoundException e) {
            Logger.logError("Cannot find 'converter.lamps'", e);
        }
        catch (IOException e) {
            Logger.logError("Problem reading 'converter.lamps'", e);
        }
        return synonyms;
    }

    private static String toPart(String line) {
        return LampManager.unquote(line.substring(line.indexOf("=>") + 2));
    }

    private static String fromPart(String line) {
        return LampManager.unquote(line.substring(0, line.indexOf("=>")));
    }

    private static String unquote(String s) {
        if (s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1).trim();
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1).trim();
        }
        if (s.startsWith("\"")) {
            return s.substring(1, s.length()).trim();
        }
        return s.trim();
    }

    @Override
    public boolean legal(String lamp) {
        this.makeUpToDate();
        return this.legalLamps.contains(lamp);
    }

    @Override
    public boolean known(String lamp) {
        this.makeUpToDate();
        return this.synonyms.containsKey(lamp);
    }

    @Override
    public boolean replaceable(String lamp) {
        this.makeUpToDate();
        return this.synonyms.containsKey(lamp) && !this.synonyms.get(lamp).equalsIgnoreCase("");
    }

    @Override
    public boolean skip(String lamp) {
        this.makeUpToDate();
        return this.synonyms.containsKey(lamp) && this.synonyms.get(lamp).equalsIgnoreCase("skip");
    }

    public void dispose() {
        if (this.synonyms != null) {
            this.synonyms.clear();
            this.synonyms = null;
        }
        if (this.legalLamps != null) {
            this.legalLamps.clear();
            this.legalLamps = null;
        }
    }

    @Override
    public List<String> suggest(String lamp) {
        return this.suggest(lamp, "");
    }

    @Override
    public List<String> suggest(String lampStart, String lampEnd) {
        this.makeUpToDate();
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String legalLamp : this.legalLamps) {
            String lampUC;
            if (legalLamp.equals(lampStart + lampEnd)) continue;
            if (legalLamp.startsWith(lampStart)) {
                suggestions.add(legalLamp);
                continue;
            }
            if (legalLamp.contains(lampStart + lampEnd)) {
                suggestions.add(0, legalLamp);
                continue;
            }
            String legalUC = legalLamp.toUpperCase();
            if (legalUC.contains(lampUC = (lampStart + lampEnd).toUpperCase())) {
                suggestions.add(legalLamp);
                continue;
            }
            if (!legalUC.replace(" ", "").contains(lampUC.replace(" ", ""))) continue;
            suggestions.add(legalLamp);
        }
        return suggestions;
    }

    @Override
    public String correct(String lamp) {
        String result = this.synonyms.get(lamp);
        return result == null ? "" : result;
    }

    private void makeUpToDate() {
        IFile conversions = this.project.getFile(CONVERTER_LAMPS);
        if (conversions.exists() && this.timestamp != conversions.getModificationStamp()) {
            this.init();
        }
    }
}

