/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.handler;

import com.fold1.eulumdat.tools.EulumdatToolsActivator;
import com.fold1.eulumdat.tools.lamps.LampManagerPool;
import com.fold1.eulumdat.tools.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Bundle;

public class CreateConverterLampsHandler
extends AbstractHandler {
    private static final String CANNOT_FIND_DEFAULT_CONVERTER_LAMPS = "Cannot find default 'converter.lamps'";
    private static final Path CONVERTER_DEFAULT = new Path("/defaults/converter.lamps");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object next = objectArray[n2];
            if (next instanceof IProject) {
                IProject project = (IProject)next;
                InputStream source = null;
                try {
                    if (!project.isAccessible() || !project.hasNature("com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature") || project.findMember("converter.lamps") != null) {
                        return null;
                    }
                    try {
                        source = CreateConverterLampsHandler.createConverter(project);
                        break;
                    }
                    catch (IOException | CoreException e) {
                        Logger.logError(CANNOT_FIND_DEFAULT_CONVERTER_LAMPS, e);
                        throw new ExecutionException(CANNOT_FIND_DEFAULT_CONVERTER_LAMPS, e);
                    }
                }
                finally {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public static InputStream createConverter(IProject project) throws IOException, CoreException {
        Logger.logInfo("Adding 'converter.lamps' to : " + project.getName());
        IFile newconverter = project.getFile("/converter.lamps");
        Bundle b = EulumdatToolsActivator.getDefault().getBundle();
        InputStream source = FileLocator.openStream((Bundle)b, (IPath)CONVERTER_DEFAULT, (boolean)false);
        newconverter.create(source, true, null);
        LampManagerPool.getManager(project);
        return source;
    }
}

