/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.handler;

import com.fold1.data.EulumdatFactory;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.Ies;
import com.fold1.data.IesData;
import com.fold1.data.IesFactory;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.exceptions.ParserException;
import java.io.File;
import java.io.PrintWriter;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertIESCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!RegistrationController.isOKToUse(true)) {
            return null;
        }
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        String name = "undefined";
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block15: {
                Object object = objectArray[n2];
                IFile config = (IFile)object;
                if (Utils.isIES(config.getName())) {
                    try {
                        name = event.getCommand().getName();
                        IesData ies = IesFactory.iesDataFromFile((File)config.getRawLocation().toFile());
                        IEulumdatRO eul = EulumdatFactory.eulumdatROFromIes((Ies)ies);
                        FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                        dialog.setFilterNames(new String[]{"All Files (*.*)"});
                        dialog.setFilterExtensions(new String[]{"*.*"});
                        dialog.setFilterPath(config.getProject().getFullPath().toString());
                        String out = config.getName().replace("." + config.getFileExtension(), "") + ".ldt";
                        dialog.setFileName(out);
                        String destination = dialog.open();
                        if (destination == null) break block15;
                        Throwable throwable = null;
                        Object var15_18 = null;
                        try (PrintWriter output = new PrintWriter(destination, ResourcesPlugin.getEncoding());){
                            output.print(eul.toString());
                            output.close();
                            config.getProject().refreshLocal(2, null);
                            Logger.logInfo("Converted IES to : " + destination);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (ParserException e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(e.getMessage());
                        sb.append("\nin '");
                        sb.append(e.getFilename());
                        sb.append("' on line ");
                        sb.append(e.getLineNumber());
                        sb.append(".");
                        String msg = sb.toString();
                        IStatus status = Logger.createStatus(4, 1, msg, e.getCause());
                        Logger.log(status);
                        ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)name, (String)"The IES file could not be parsed correctly", (IStatus)status);
                    }
                    catch (Exception e) {
                        IStatus status = Logger.createStatus(4, 1, e.getMessage(), e.getCause());
                        Logger.log(status);
                        ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)name, (String)"The IES file could not be parsed correctly", (IStatus)status);
                    }
                }
            }
            ++n2;
        }
        return null;
    }
}

