/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.ies.text;

import com.fold1.eulumdat.tools.editors.ies.text.DataScanner;
import com.fold1.eulumdat.tools.editors.ies.text.IesContentAssistant;
import com.fold1.eulumdat.tools.editors.ies.text.IesPartitionScanner;
import com.fold1.eulumdat.tools.editors.ies.text.IesTextEditorColorManager;
import com.fold1.eulumdat.tools.editors.ies.text.IesnaTagScanner;
import com.fold1.eulumdat.tools.editors.ies.text.KeywordScanner;
import com.fold1.eulumdat.tools.editors.ies.text.TiltScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class IesSourceViewerConfiguration
extends SourceViewerConfiguration {
    private final IesTextEditorColorManager colorManager;
    private DataScanner dataScanner;
    private IesnaTagScanner iesnaTagScanner;
    private KeywordScanner keywordScanner;
    private final IPreferenceStore preferenceStore;
    private TiltScanner tiltScanner;

    public IesSourceViewerConfiguration(IPreferenceStore preferenceStore, IesTextEditorColorManager colorManager) {
        this.preferenceStore = preferenceStore;
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return IesPartitionScanner.PARTITION_TYPES;
    }

    private ITokenScanner getTiltScanner() {
        if (this.tiltScanner == null) {
            this.tiltScanner = new TiltScanner(this.colorManager, this.preferenceStore);
        }
        return this.tiltScanner;
    }

    private ITokenScanner getDataScanner() {
        if (this.dataScanner == null) {
            this.dataScanner = new DataScanner(this.colorManager, this.preferenceStore);
        }
        return this.dataScanner;
    }

    private ITokenScanner getIesnaTagScanner() {
        if (this.iesnaTagScanner == null) {
            this.iesnaTagScanner = new IesnaTagScanner(this.colorManager, this.preferenceStore);
        }
        return this.iesnaTagScanner;
    }

    private ITokenScanner getKeywordScanner() {
        if (this.keywordScanner == null) {
            this.keywordScanner = new KeywordScanner(this.colorManager, this.preferenceStore);
        }
        return this.keywordScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getIesnaTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__iesna__");
        reconciler.setRepairer((IPresentationRepairer)dr, "__iesna__");
        dr = new DefaultDamagerRepairer(this.getKeywordScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ies_keyword__");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ies_keyword__");
        dr = new DefaultDamagerRepairer(this.getTiltScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ies_tilt__");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ies_tilt__");
        dr = new DefaultDamagerRepairer(this.getDataScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        return new IesContentAssistant(sourceViewer);
    }
}

