/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.ies.text;

import com.fold1.data.IesKeywordLabels;
import com.fold1.eulumdat.tools.log.Logger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class IesKeywordContentAssistProcessor
implements IContentAssistProcessor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        try {
            char current;
            int documentLength = viewer.getDocument().getLength();
            int currentLine = viewer.getDocument().getLineOfOffset(offset);
            IRegion lineInfo = viewer.getDocument().getLineInformation(currentLine);
            int start = offset;
            while (start > 0 && start > lineInfo.getOffset()) {
                char current2 = viewer.getDocument().getChar(start);
                if (current2 == ']') {
                    return null;
                }
                if (current2 == '[') {
                    ++start;
                    break;
                }
                --start;
            }
            ++start;
            int end = offset;
            while (end < documentLength && end < lineInfo.getOffset() + lineInfo.getLength() && (current = viewer.getDocument().getChar(end)) != ' ' && current != '\t') {
                if (current == ']') {
                    ++end;
                    break;
                }
                ++end;
            }
            String prefix = viewer.getDocument().get(start, offset - start).toUpperCase();
            String suffix = viewer.getDocument().get(offset, end - offset).toUpperCase();
            if (Platform.inDevelopmentMode()) {
                System.out.println("PREFIX: " + prefix);
                System.out.println("SUFFIX: " + suffix);
            }
            this.buildProposals(result, start - 1, end, prefix, IesKeywordLabels.MULTIPLE_KEYWORDS_ARRAY);
            this.buildProposals(result, start - 1, end, prefix, IesKeywordLabels.UNIQUE_KEYWORDS_ARRAY);
            return result.toArray(new ICompletionProposal[0]);
        }
        catch (BadLocationException e) {
            Logger.logError(e.getMessage(), e);
        }
        return result.toArray(new ICompletionProposal[0]);
    }

    public void buildProposals(List<ICompletionProposal> result, int start, int end, String prefix, String[] keywords) {
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (keyword.startsWith(prefix)) {
                result.add((ICompletionProposal)new CompletionProposal("[" + keyword + "]", start, end - start, end));
            }
            ++n2;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'['};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

