/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.ies;

import com.fold1.data.Ies;
import com.fold1.data.IesKeywordLabels;
import com.fold1.data.IesParameterEntry;
import com.fold1.eulumdat.tools.editors.ies.IesEditorUtils;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class IesPropertiesEditorPart
extends EditorPart {
    public static final String ID = "com.fold1.eulumdat.tools.editors.ies.IesPropertiesEditorPart";
    private Table table = null;
    private TableViewer tableViewer = null;
    private IDocumentProvider fileDocumentProvider;
    private Ies ies;
    private boolean dirty;
    private RemoveKeywordAction removeKeywordAction;
    private static Map<String, IAction> keywordActions = new TreeMap<String, IAction>();

    private synchronized Map<String, IAction> getKeywordInsertActions() {
        if (keywordActions.isEmpty()) {
            InsertKeywordAction action;
            for (String keyword : IesKeywordLabels.UNIQUE_KEYWORDS) {
                action = new InsertKeywordAction(keyword);
                keywordActions.put(keyword, action);
            }
            for (String keyword : IesKeywordLabels.MULTIPLE_KEYWORDS) {
                action = new InsertKeywordAction(keyword);
                keywordActions.put(keyword, action);
            }
        }
        return keywordActions;
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout(256));
        Composite tableComposite = new Composite(container, 0);
        TableColumnLayout tcl_tableComposite = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcl_tableComposite);
        this.tableViewer = new TableViewer(tableComposite, 67584);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewerColumn keywordColumn = new TableViewerColumn(this.tableViewer, 0);
        keywordColumn.setLabelProvider((CellLabelProvider)new KeywordColumnLabelProviderExtension());
        TableColumn tblclmnkeyword = keywordColumn.getColumn();
        tcl_tableComposite.setColumnData((Widget)tblclmnkeyword, (ColumnLayoutData)new ColumnWeightData(40, 150, true));
        tblclmnkeyword.setText("[KEYWORD]");
        TableViewerColumn valueColumn = new TableViewerColumn(this.tableViewer, 0);
        valueColumn.setLabelProvider((CellLabelProvider)new ValueColumnLabelProviderExtension());
        TableColumn tblclmnValue = valueColumn.getColumn();
        tcl_tableComposite.setColumnData((Widget)tblclmnValue, (ColumnLayoutData)new ColumnWeightData(60, 150, true));
        tblclmnValue.setText("Value");
        valueColumn.setEditingSupport((EditingSupport)new ValueEditingSupport(this.tableViewer));
        this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.ies = IesEditorUtils.parseIes(this.getEditorInput());
        this.tableViewer.setInput((Object)this.ies);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(listener -> this.fillKeywordMenu(listener));
        Menu contextMenu = menuManager.createContextMenu((Control)this.table);
        this.table.setMenu(contextMenu);
        this.getEditorSite().registerContextMenu("#IesProperties", menuManager, (ISelectionProvider)this.tableViewer, false);
        this.removeKeywordAction = new RemoveKeywordAction();
    }

    private void fillKeywordMenu(IMenuManager manager) {
        manager.add((IAction)this.removeKeywordAction);
        manager.add((IContributionItem)new Separator());
        for (Map.Entry<String, IAction> entry : this.getKeywordInsertActions().entrySet()) {
            if (IesKeywordLabels.UNIQUE_KEYWORDS.contains(entry.getKey()) && this.ies.hasProperty("[" + entry.getKey() + "]")) continue;
            manager.add(entry.getValue());
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.table.setFocus();
    }

    public IDocumentProvider getDocumentProvider() {
        return this.fileDocumentProvider;
    }

    public void setDocumentProvider(IDocumentProvider iDocumentProvider) {
        this.fileDocumentProvider = iDocumentProvider;
    }

    public void updateIes() {
        this.getDocumentProvider().getDocument((Object)this.getEditorInput()).set(this.ies.toString());
        this.ies = IesEditorUtils.parseIes(this.getEditorInput());
        this.tableViewer.setInput((Object)this.ies);
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Ies) {
                Ies ies = (Ies)inputElement;
                return ies.getProperties().toArray(new IesParameterEntry[0]);
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class InsertKeywordAction
    extends Action
    implements IAction {
        private final String keyword;

        public InsertKeywordAction(String keyword) {
            super("Insert [" + keyword + "]");
            this.keyword = "[" + keyword + "]";
        }

        public void run() {
            IesPropertiesEditorPart.this.ies.addProperty(this.keyword, "");
            IesPropertiesEditorPart.this.updateIes();
        }
    }

    private final class KeywordColumnLabelProviderExtension
    extends ColumnLabelProvider {
        private KeywordColumnLabelProviderExtension() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IesParameterEntry) {
                IesParameterEntry entry = (IesParameterEntry)element;
                return (String)entry.getKey();
            }
            return "";
        }
    }

    public class RemoveKeywordAction
    extends Action
    implements IAction {
        private RemoveKeywordAction() {
            this("Remove keyword");
        }

        private RemoveKeywordAction(String text) {
            super(text, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        }

        public void run() {
            StructuredSelection ss = (StructuredSelection)IesPropertiesEditorPart.this.tableViewer.getStructuredSelection();
            if (ss.isEmpty()) {
                return;
            }
            IesPropertiesEditorPart.this.ies.removeProperty((IesParameterEntry)ss.getFirstElement());
            IesPropertiesEditorPart.this.updateIes();
        }
    }

    private final class ValueColumnLabelProviderExtension
    extends ColumnLabelProvider {
        private ValueColumnLabelProviderExtension() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IesParameterEntry) {
                IesParameterEntry entry = (IesParameterEntry)element;
                return (String)entry.getValue();
            }
            return "";
        }
    }

    public class ValueEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;
        private final TextCellEditor editor;

        public ValueEditingSupport(TableViewer tableViewer) {
            super((ColumnViewer)tableViewer);
            this.viewer = tableViewer;
            this.editor = new TextCellEditor((Composite)this.viewer.getTable());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((IesParameterEntry)element).getValue();
        }

        protected void setValue(Object element, Object value) {
            ((IesParameterEntry)element).setValue((Object)((String)value));
            IesPropertiesEditorPart.this.updateIes();
        }
    }
}

