/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.ies;

import com.fold1.data.Ies;
import com.fold1.data.IesData;
import com.fold1.data.IesFactory;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.exceptions.ParserException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;

public final class IesEditorUtils {
    public static Ies parseIes(IEditorInput editorInput) {
        IesData ies2 = null;
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editorInput).getFile();
            try {
                Throwable throwable = null;
                Object var4_8 = null;
                try (InputStream stream = file.getContents();){
                    boolean silent = IesFactory.isSilent();
                    ies2 = IesFactory.iesDataFromStream((InputStream)stream, (String)file.getName());
                    IesFactory.setSilent((boolean)silent);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ParserException | IOException | CoreException e) {
                Logger.logError("Problem reading IES in workspace", e);
            }
        } else if (editorInput instanceof FileStoreEditorInput) {
            FileStoreEditorInput fsInput = (FileStoreEditorInput)editorInput;
            try {
                String name = URLDecoder.decode(fsInput.getURI().getRawPath(), "UTF-8");
                ies2 = IesFactory.iesDataFromString((String)name);
            }
            catch (ParserException | IOException e) {
                Logger.logError("Problem reading IES in file system", e);
            }
        }
        return ies2;
    }
}

