/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.ies;

import com.fold1.eulumdat.tools.editors.ies.IesChartEditorPart;
import com.fold1.eulumdat.tools.editors.ies.IesPropertiesEditorPart;
import com.fold1.eulumdat.tools.editors.ies.text.IESTextEditor;
import com.fold1.eulumdat.tools.log.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class IesEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private IESTextEditor editor;
    private IesPropertiesEditorPart iesPropertiesEditor;
    private IesChartEditorPart iesChartEditor;

    public IesEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    void createPage0() {
        try {
            this.editor = new IESTextEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, "Source");
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested IES text editor", null, (IStatus)e.getStatus());
        }
    }

    void createPage1() {
        try {
            this.iesPropertiesEditor = new IesPropertiesEditorPart();
            this.iesPropertiesEditor.setDocumentProvider(this.editor.getDocumentProvider());
            int index = this.addPage((IEditorPart)this.iesPropertiesEditor, this.getEditorInput());
            this.setPageText(index, "Properties");
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested IES properties editor", null, (IStatus)e.getStatus());
        }
    }

    void createPage2() {
        try {
            this.iesChartEditor = new IesChartEditorPart();
            this.iesChartEditor.setDocumentProvider(this.editor.getDocumentProvider());
            int index = this.addPage((IEditorPart)this.iesChartEditor, this.getEditorInput());
            this.setPageText(index, "Preview");
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested IES chart editor", null, (IStatus)e.getStatus());
        }
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
        if (Platform.inDevelopmentMode()) {
            this.createPage2();
        }
        this.setPartName(this.editor.getTitle());
    }

    public void setFocus() {
        switch (this.getActivePage()) {
            case 0: {
                this.getEditor(0).setFocus();
                break;
            }
            case 1: {
                this.getEditor(1).setFocus();
                break;
            }
            case 2: {
                Logger.logInfo("Focus on IES chart tab");
                this.getEditor(2).setFocus();
                break;
            }
            default: {
                Logger.logError("Nonexistent Page !!", new IllegalStateException());
            }
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor1 = this.getEditor(0);
        editor1.doSaveAs();
        this.setInput(editor1.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        Logger.logInfo("IES Editor Selecting page " + newPageIndex);
        if (newPageIndex != 2) {
            super.pageChange(newPageIndex);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(() -> {
                IWorkbenchPage[] pages;
                IWorkbenchPage[] iWorkbenchPageArray = pages = this.getSite().getWorkbenchWindow().getPages();
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage page = iWorkbenchPageArray[n2];
                    if (((FileEditorInput)this.editor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                        IEditorPart editorPart = page.findEditor(this.editor.getEditorInput());
                        page.closeEditor(editorPart, true);
                    }
                    ++n2;
                }
            });
        }
    }
}

