/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.graph;

import com.fold1.chart.DiagramColorFontSizeSupplier;
import com.fold1.data.Eulumdat2;
import com.fold1.data.ICGamma;
import com.fold1.data.IntensityCalculator;
import com.fold1.data.Symmetry;
import com.fold1.data.ThreePoints;
import com.fold1.eulumdat.tools.editors.graph.AbstractJava2DDiagram;
import com.fold1.eulumdat.tools.editors.graph.CGammaDrawer;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.util.NumberOutput;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.eclipse.swt.widgets.Composite;

public class PhotometricJava2dDiagram
extends AbstractJava2DDiagram
implements DiagramColorFontSizeSupplier {
    private static final int INSET = 40;
    private Color backGroundColor = Color.WHITE;
    private Color textColor = Color.DARK_GRAY;
    private Color emergencyColor = new Color(0.2f, 1.0f, 0.2f, 1.0f);
    private Color planeC0C180Color = new Color(1.0f, 1.0f, 0.0f, 0.5f);
    private Color planeC90C270Color = new Color(0.2f, 0.2f, 1.0f, 0.5f);
    private Color axisColor = Color.DARK_GRAY;
    private Color frameColor = Color.BLACK;
    private String fontName = "Arial";
    private int size = 0;
    private static final int CGAMMADIAGRAM = 0;
    private static final int HALCILLCONE = 1;
    private static final int HALCILLCONE2 = 2;
    private static final int EMERGENCY = 3;
    private static final double ONELUX = 1.0;
    private static final double HALFLUX = 0.5;
    private static final double TINY = 0.001;
    private static final int EMERGENCYPOINTS = 25;
    private static final double SMALLESTSTEP = 1.0E-5;
    private static final double MAXRADIUS = 10.0;
    private static final double SCALE_START = 50.0;
    private int diagramSelected;
    private int lampSelected;
    private Eulumdat2 eulumdat;

    public final void setDiagramSelected(int diagramSelected) {
        this.diagramSelected = diagramSelected;
    }

    public PhotometricJava2dDiagram(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public void awtPaint(Graphics2D g2d, int width, int height) {
        String s = null;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.prepareDiagram(g2d, width, height);
        switch (this.diagramSelected) {
            case 0: {
                this.drawCGamma(g2d, this.eulumdat);
                return;
            }
            case 1: {
                this.drawHalfIntensityCone(g2d, this.eulumdat, 1);
                return;
            }
            case 2: {
                this.drawHalfIntensityCone(g2d, this.eulumdat, 2);
                return;
            }
            case 3: {
                this.drawEmergency(g2d, this.eulumdat);
                return;
            }
        }
        s = "Not Yet Implemented ";
        this.drawDummy(g2d, s);
    }

    private void drawEmergency(Graphics2D g2d, Eulumdat2 eu) {
        g2d.translate(20, 20);
        int x1 = this.size / 10;
        int mark = x1 / 6;
        int x2 = 9 * this.size / 10;
        int i = 0;
        while (i < 5) {
            int dx = this.size * (1 + 2 * i) / 10;
            g2d.setColor(this.axisColor);
            g2d.drawLine(x1 - mark, dx, x2, dx);
            g2d.drawLine(dx, x1 - mark, dx, x2);
            g2d.setColor(this.textColor);
            g2d.setFont(new Font(this.fontName, 0, this.size / 30));
            this.centerString(g2d, NumberOutput.digits((double)((double)i * 1.5), (int)1), dx, 0.5f * (float)x1, false);
            this.centerString(g2d, NumberOutput.digits((double)((double)i * 1.5), (int)1), 0.5f * (float)x1, dx, false);
            ++i;
        }
        g2d.setColor(this.emergencyColor);
        g2d.clipRect(1 + this.size / 10, 1 + this.size / 10, 8 * this.size / 10, 8 * this.size / 10);
        g2d.translate(this.size / 10, this.size / 10);
        double t = 2.0 * (double)this.size / 15.0;
        g2d.scale(t, t);
        g2d.setStroke(new BasicStroke((float)(1.5 / t)));
        this.drawEmergencySpacingCurve(g2d, eu, 1.0);
        g2d.setStroke(new BasicStroke((float)(1.5 / t), 2, 2, 0.0f, new float[]{(float)(8.0 / t), (float)(8.0 / t)}, 0.0f));
        this.drawEmergencySpacingCurve(g2d, eu, 0.5);
    }

    private void drawEmergencySpacingCurve(Graphics2D g2d, Eulumdat2 eu, double treshold) {
        double[] heights = new double[25];
        double[] spacings = new double[25];
        GeneralPath curve = new GeneralPath();
        double step = 0.5;
        int i = 0;
        double h = 1.0E-7;
        while (h <= 6.1) {
            double r = 0.0;
            while (r <= 10.0) {
                block8: {
                    double c = 0.0;
                    double gamma = Math.atan(r / h);
                    gamma = PhotometricJava2dDiagram.normalizeAngleGamma(gamma);
                    double cosgamma = Math.cos(gamma);
                    try {
                        heights[i] = h;
                        spacings[i] = r;
                        if (r <= 0.0 && step <= 0.0) {
                            step = 0.5;
                            r = 10.0;
                            break;
                        }
                        double lux = eu.getIntensity(c, gamma) * eu.getLuminaireKiloLumen(this.lampSelected) * cosgamma * cosgamma * cosgamma / (h * h);
                        if (step > 0.0 && lux < treshold || step < 0.0 && lux > treshold) {
                            step = -step / 2.0;
                        }
                        if (Math.abs(lux - treshold) < 0.001 || Math.abs(step) < 1.0E-5) {
                            step = 0.5;
                            r = 10.0;
                        }
                        break block8;
                    }
                    catch (IllegalArgumentException e) {
                        Logger.logError("Illegal argument drawing Emergency Spacing", e);
                    }
                    break;
                }
                r += step;
            }
            ++i;
            h += 0.25;
        }
        double[] cx = PhotometricJava2dDiagram.findCoefsOpen(spacings, 24);
        double[] cy = PhotometricJava2dDiagram.findCoefsOpen(heights, 24);
        i = 0;
        while (i < 24) {
            int nexti = (i + 1) % 25;
            CubicCurve2D.Double bezier = new CubicCurve2D.Double(spacings[i], heights[i], spacings[i] + cx[i], heights[i] + cy[i], spacings[nexti] - cx[nexti], heights[nexti] - cy[nexti], spacings[nexti], heights[nexti]);
            curve.append(bezier, true);
            ++i;
        }
        g2d.setColor(this.emergencyColor);
        g2d.draw(curve);
    }

    public static double normalizeAngleGamma(double a) {
        double norm = a % Math.PI;
        if (norm < 0.0) {
            norm += Math.PI;
        }
        return norm;
    }

    public static double[] findCoefsOpen(double[] a, int n) {
        double[] b = new double[n + 1];
        double[] r = new double[n + 1];
        double[] c = new double[n + 1];
        b[0] = 2.0 * (a[1] - a[0]) / 3.0;
        int i = 1;
        while (i < n) {
            b[i] = a[i + 1] - a[i - 1];
            ++i;
        }
        b[n] = 2.0 * (a[n] - a[n - 1]) / 3.0;
        r[n] = 1.0;
        r[n - 1] = 1.0;
        i = n - 2;
        while (i >= 0) {
            r[i] = 4.0 * r[i + 1] - r[i + 2];
            --i;
        }
        i = 1;
        while (i <= n) {
            r[i] = -r[i];
            i += 2;
        }
        c[0] = 0.0;
        i = n;
        while (i >= 0) {
            c[0] = c[0] + r[i] * b[i];
            --i;
        }
        c[0] = c[0] / (r[0] + r[1]);
        c[1] = b[0] - c[0];
        i = 1;
        while (i < n) {
            c[i + 1] = b[i] - 4.0 * c[i] - c[i - 1];
            ++i;
        }
        return c;
    }

    public static double[] findCoefsClosed(double[] a, int n) {
        double[] b = new double[n];
        double[] r = new double[n];
        double[] c = new double[n];
        b[0] = a[1] - a[n - 1];
        int i = 1;
        while (i < n - 1) {
            b[i] = a[i + 1] - a[i - 1];
            ++i;
        }
        b[n - 1] = a[0] - a[n - 2];
        int m = n / 2;
        r[m] = 1.0;
        r[m - 1] = (n & 1) != 0 ? 5 : 2;
        i = m - 2;
        while (i >= 0) {
            r[i] = 4.0 * r[i + 1] - r[i + 2];
            --i;
        }
        i = 1;
        while (i <= m) {
            r[i] = -r[i];
            i += 2;
        }
        i = m + 1;
        while (i < n) {
            r[i] = r[n - i];
            ++i;
        }
        c[0] = 0.0;
        c[n - 1] = 0.0;
        i = n - 1;
        while (i >= 0) {
            c[0] = c[0] + r[i] * b[i];
            int n2 = n - 1;
            c[n2] = c[n2] + r[i] * b[n - 1 - i];
            --i;
        }
        double den = 4.0 * r[0] + r[1] + r[n - 1];
        c[0] = c[0] / den;
        int n3 = n - 1;
        c[n3] = c[n3] / den;
        c[1] = b[0] - 4.0 * c[0] - c[n - 1];
        i = 1;
        while (i < n - 2) {
            c[i + 1] = b[i] - 4.0 * c[i] - c[i - 1];
            ++i;
        }
        return c;
    }

    private void drawHalfIntensityCone(Graphics2D g2d, Eulumdat2 eu, int mult) {
        g2d.translate(20, 20);
        double halfIangle = eu.getHalfIntensityAngle(0.0);
        double halfIangle2 = eu.getHalfIntensityAngle(1.5707963267948966);
        halfIangle += halfIangle2;
        double radiusFactor = Math.tan(halfIangle *= 0.5);
        g2d.setColor(this.planeC90C270Color);
        Shape clip = g2d.getClip();
        g2d.setClip(null);
        Rectangle f = new Rectangle(this.size / 12, this.size / 12, 10 * this.size / 12, 10 * this.size / 12);
        g2d.clip(f);
        Polygon p = new Polygon();
        double halfsize = 0.5 * (double)this.size;
        p.addPoint((int)halfsize, (int)halfsize);
        p.addPoint((int)(halfsize - radiusFactor * 5.0 * (double)this.size / 12.0), 11 * this.size / 12);
        p.addPoint((int)(halfsize + radiusFactor * 5.0 * (double)this.size / 12.0), 11 * this.size / 12);
        g2d.setColor(this.planeC0C180Color);
        g2d.fillPolygon(p);
        g2d.setClip(clip);
        g2d.setColor(this.textColor);
        g2d.setFont(new Font(this.fontName, 0, this.size / 26));
        int i = 0;
        while (i < 10) {
            int y = (int)((2.0 + (double)i) * ((double)this.size / 12.0));
            int x = this.size / 10;
            int c = 5 * x;
            int r = 9 * x;
            switch (i) {
                case 0: {
                    g2d.drawString("Cone Angle " + NumberOutput.digits((double)(114.59155902616465 * halfIangle), (int)0) + "\u00b0", x, y);
                    break;
                }
                case 1: {
                    g2d.drawString("Lamp flux " + NumberOutput.digits((double)eu.getLampSetRO(this.lampSelected).getTotalLumen(), (int)1) + " lumen", x, y);
                    break;
                }
                case 3: {
                    g2d.drawString("h", x, y);
                    String es = "\u2205";
                    g2d.drawString(es, (float)c - PhotometricJava2dDiagram.stringLength(g2d, es) / 2.0f, (float)y);
                    es = "Emax";
                    g2d.drawString(es, (float)r - PhotometricJava2dDiagram.stringLength(g2d, es), (float)y);
                    break;
                }
                case 4: {
                    g2d.drawString("(m)", x, y);
                    String es = "(m)";
                    g2d.drawString(es, (float)c - PhotometricJava2dDiagram.stringLength(g2d, es) / 2.0f, (float)y);
                    es = "(lux)";
                    g2d.drawString(es, (float)r - PhotometricJava2dDiagram.stringLength(g2d, es), (float)y);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    String es;
                    g2d.drawString("" + mult * (i - 4), x, y);
                    try {
                        double e = eu.getIntensity(0.0, 0.0) * eu.getLuminaireKiloLumen(this.lampSelected) / (double)(mult * (i - 4) * mult * (i - 4));
                        es = NumberOutput.digits((double)(2.0 * ((double)(mult * (i - 4)) * radiusFactor)), (int)1);
                        g2d.drawString(es, (float)c - PhotometricJava2dDiagram.stringLength(g2d, es) / 2.0f, (float)y);
                        es = NumberOutput.digits((double)e, (int)1);
                        g2d.drawString(es, (float)r - PhotometricJava2dDiagram.stringLength(g2d, es), (float)y);
                    }
                    catch (IllegalArgumentException e) {
                        Logger.logError("Illegal argument drawing intensity cone", e);
                    }
                    break;
                }
            }
            ++i;
        }
    }

    static float stringLength(Graphics2D g2d, String es) {
        FontRenderContext frc = g2d.getFontRenderContext();
        Rectangle2D bounds = g2d.getFont().getStringBounds(es, frc);
        return (float)bounds.getWidth();
    }

    public void centerString(Graphics2D g2d, String es, float x, float y, boolean erase) {
        FontRenderContext frc = g2d.getFontRenderContext();
        Rectangle2D bounds = g2d.getFont().getStringBounds(es, frc);
        LineMetrics metrics = g2d.getFont().getLineMetrics(es, frc);
        float fw = (float)bounds.getWidth();
        float lineHeight = metrics.getHeight();
        float ascent = metrics.getAscent();
        if (erase) {
            Rectangle2D.Double erased = new Rectangle2D.Double(x - fw / 2.0f - ascent / 12.0f, y - ascent + ascent / 4.0f, fw + ascent / 6.0f, lineHeight);
            g2d.setColor(this.backGroundColor);
            g2d.fill(erased);
        }
        g2d.setColor(this.textColor);
        g2d.drawString(es, x - fw / 2.0f, y + lineHeight - ascent);
    }

    private void drawCGamma(Graphics2D g2d, Eulumdat2 eu) {
        Ellipse2D.Double circle;
        if (eu == null) {
            return;
        }
        IntensityCalculator temp = eu.getIntensityCalculatorStrategy();
        eu.setIntensityCalculatorStrategy((IntensityCalculator)new ThreePoints((ICGamma)eu));
        Font font = new Font(this.fontName, 0, this.size / 20);
        g2d.setFont(font);
        g2d.translate(20, 20);
        CGammaDrawer drawer = new CGammaDrawer(eu);
        g2d.setColor(this.textColor);
        Object label = "I (cd/klm)";
        g2d.drawString((String)label, 10, this.size - 10);
        g2d.setColor(this.planeC0C180Color);
        g2d.fillRect(10, 10 + this.size / 20 - font.getSize(), font.getSize(), font.getSize());
        g2d.setColor(this.planeC90C270Color);
        g2d.fillRect(10, 10 + this.size / 20, font.getSize(), font.getSize());
        g2d.setColor(this.textColor);
        g2d.drawString("C180", 10 + font.getSize(), 10 + this.size / 20);
        g2d.drawString("C270", 10 + font.getSize(), 10 + this.size / 20 + font.getSize());
        g2d.setColor(this.textColor);
        label = "\u03b7 = " + NumberOutput.digits((double)eu.getEfficacy(), (int)1) + "%";
        g2d.drawString((String)label, (float)this.size - 10.0f - PhotometricJava2dDiagram.stringLength(g2d, (String)label), (float)this.size - 10.0f);
        g2d.drawString("C0", (float)this.size - 10.0f - PhotometricJava2dDiagram.stringLength(g2d, "C0") - (float)font.getSize(), 10.0f + (float)this.size / 20.0f);
        g2d.drawString("C90", (float)this.size - 10.0f - PhotometricJava2dDiagram.stringLength(g2d, "C90") - (float)font.getSize(), 10.0f + (float)this.size / 20.0f + (float)font.getSize());
        g2d.setColor(this.planeC0C180Color);
        g2d.fillRect(this.size - 10 - font.getSize(), 10 + this.size / 20 - font.getSize(), font.getSize(), font.getSize());
        g2d.setColor(this.planeC90C270Color);
        g2d.fillRect(this.size - 10 - font.getSize(), 10 + this.size / 20, font.getSize(), font.getSize());
        g2d.translate(this.size / 2, this.size / 2);
        g2d.scale((double)this.size / drawer.getScale(), (double)this.size / drawer.getScale());
        g2d.scale(0.9, 0.9);
        double dx = 0.5 * drawer.getScaleX() - drawer.getMaxX();
        double dy = 0.5 * drawer.getScaleY() - drawer.getMaxY();
        g2d.translate(dx, dy);
        g2d.setColor(this.axisColor);
        g2d.setStroke(new BasicStroke((float)(2.0 / drawer.getScale())));
        int axis = (int)drawer.getScale();
        g2d.drawLine(-axis, 0, axis, 0);
        g2d.drawLine(0, -axis, 0, axis);
        double scaleStep = drawer.getScaleStep(50.0);
        int nbOfSlices = 24;
        int len = 2 * (int)drawer.getScale();
        int i = 0;
        while (i < nbOfSlices) {
            g2d.setColor(this.axisColor);
            g2d.drawLine((int)scaleStep, 0, len, 0);
            g2d.rotate(Math.PI * -2 / (double)nbOfSlices);
            ++i;
        }
        double scale = (double)this.size / (18.0 * g2d.getTransform().getScaleX());
        Font font2 = new Font(this.fontName, 0, (int)scale);
        g2d.setFont(font2);
        double s = 0.0;
        do {
            g2d.setColor(this.axisColor);
            circle = new Ellipse2D.Double(-s, -s, 2.0 * s, 2.0 * s);
            g2d.draw(circle);
            g2d.setColor(this.textColor);
            this.centerString(g2d, NumberOutput.digits((double)s, (int)0), 0.0f, (float)s, true);
            this.centerString(g2d, NumberOutput.digits((double)s, (int)0), 0.0f, (float)(-s), true);
        } while ((s += scaleStep) < drawer.getScale());
        circle = new Ellipse2D.Double(-s, -s, 2.0 * s, 2.0 * s);
        g2d.draw(circle);
        g2d.setColor(this.planeC0C180Color);
        g2d.fillPolygon(drawer.getC0C180Polygon());
        if (eu.getIsym() != Symmetry.ROTATION) {
            g2d.setColor(this.planeC90C270Color);
            g2d.fillPolygon(drawer.getC90C270Polygon());
        }
        eu.setIntensityCalculatorStrategy(temp);
        drawer.dispose();
    }

    private void prepareDiagram(Graphics2D g2d, int width, int height) {
        this.size = Math.min(height, width) - 40;
        g2d.setColor(this.backGroundColor);
        g2d.fillRect(0, 0, this.size + 40, this.size + 40);
        g2d.setColor(this.frameColor);
        g2d.drawRect(0, 0, this.size + 40 - 1, this.size + 40 - 1);
        g2d.setColor(this.frameColor);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawRect(19, 19, this.size + 1, this.size + 1);
        g2d.clipRect(19, 19, this.size + 1, this.size + 1);
    }

    private void drawDummy(Graphics2D g2d, String s) {
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.yellow, this.size, this.size, Color.white));
        g2d.fillRect(0, 0, this.size, this.size);
        g2d.setFont(new Font("SansSerif", 1, 16));
        g2d.setColor(Color.blue);
        g2d.translate(this.size / 2, this.size / 2);
        int nbOfSlices = 12;
        int i = 0;
        while (i < nbOfSlices) {
            g2d.drawString(s + this.eulumdat.getProductName(), 30, 0);
            g2d.rotate(Math.PI * -2 / (double)nbOfSlices);
            ++i;
        }
    }

    public Eulumdat2 getEulumdat() {
        return this.eulumdat;
    }

    public void setEulumdat(Eulumdat2 eulumdat) {
        this.eulumdat = eulumdat;
    }

    public int getDiagramSelected() {
        return this.diagramSelected;
    }

    public int getLampSelected() {
        return this.lampSelected;
    }

    @Override
    public Color getBackGroundColor() {
        return this.backGroundColor;
    }

    public void setBackGroundColor(Color backGroundColor) {
        this.backGroundColor = backGroundColor;
    }

    @Override
    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @Override
    public Color getEmergencyColor() {
        return this.emergencyColor;
    }

    public void setEmergencyColor(Color emergencyColor) {
        this.emergencyColor = emergencyColor;
    }

    @Override
    public Color getPlaneC0C180Color() {
        return this.planeC0C180Color;
    }

    public void setPlaneC0C180Color(Color planeC0C180Color) {
        this.planeC0C180Color = planeC0C180Color;
    }

    @Override
    public Color getPlaneC90C270Color() {
        return this.planeC90C270Color;
    }

    public void setPlaneC90C270Color(Color planeC90C270Color) {
        this.planeC90C270Color = planeC90C270Color;
    }

    @Override
    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color axisColor) {
        this.axisColor = axisColor;
    }

    @Override
    public Color getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(Color frameColor) {
        this.frameColor = frameColor;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setLampSelected(int lampSelected) {
        this.lampSelected = lampSelected;
    }

    public static void reverse(int[] myArray) {
        int i = 0;
        while (i < myArray.length / 2) {
            int temp = myArray[i];
            myArray[i] = myArray[myArray.length - (i + 1)];
            myArray[myArray.length - (i + 1)] = temp;
            ++i;
        }
    }

    public static int[] reversed(int[] myArray) {
        int[] rev = new int[myArray.length];
        int i = 0;
        while (i < myArray.length) {
            rev[i] = myArray[myArray.length - (i + 1)];
            ++i;
        }
        return rev;
    }

    public static int[] append(int[] one, int[] two) {
        int[] resultArray = new int[one.length + two.length];
        System.arraycopy(one, 0, resultArray, 0, one.length);
        System.arraycopy(two, 0, resultArray, one.length, two.length);
        return resultArray;
    }
}

