/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.graph;

import com.fold1.data.Eulumdat2;
import com.fold1.eulumdat.tools.EulumdatToolsActivator;
import com.fold1.eulumdat.tools.editors.graph.PNGImage;
import com.fold1.eulumdat.tools.editors.graph.PhotometricJava2dDiagram;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.preferences.EulumdatToolsPreferences;
import com.fold1.eulumdat.tools.preferences.PreferenceChangeListener;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;

public class PhotometricDiagramViewer
extends Composite
implements PreferenceChangeListener {
    protected static final String PATHSEPARATOR = File.separator;
    Eulumdat2 eulumdat;
    private PhotometricJava2dDiagram chartCanvas = null;
    private static String[] writerNames = null;
    private Combo diagramCombo = null;
    private Combo formatCombo = null;
    private Combo lampCombo = null;
    private int selectedLamp = 0;
    private int selectedDiagram = 0;

    public PhotometricDiagramViewer(Composite composite) {
        super(composite, 0);
        this.initialize();
    }

    private static String unquote(String value) {
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        FormLayout layout = new FormLayout();
        FormData data = new FormData();
        this.setLayout((Layout)layout);
        this.chartCanvas = new PhotometricJava2dDiagram(this, 0x1000000);
        EulumdatToolsPreferences.getInstance().addPreferenceChangeListener(this);
        this.readDiagramPrefs();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(90);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.chartCanvas.setLayoutData(data);
        this.diagramCombo = new Combo((Composite)this, 12);
        this.diagramCombo.add("Polar C Gamma Distribution");
        this.diagramCombo.add("Half Center Illuminance Cone - Max 5 m");
        this.diagramCombo.add("Half Center Illuminance Cone - Max 10 m");
        this.diagramCombo.add("Emergency Spacing");
        this.diagramCombo.select(this.selectedDiagram);
        this.chartCanvas.setDiagramSelected(this.selectedDiagram);
        this.diagramCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PhotometricDiagramViewer.this.lampCombo.pack(true);
                PhotometricDiagramViewer.this.selectedDiagram = PhotometricDiagramViewer.this.diagramCombo.getSelectionIndex();
                PhotometricDiagramViewer.this.chartCanvas.setDiagramSelected(PhotometricDiagramViewer.this.selectedDiagram);
                PhotometricDiagramViewer.this.chartCanvas.redraw();
            }

            public void widgetSelected(SelectionEvent e) {
                PhotometricDiagramViewer.this.selectedDiagram = PhotometricDiagramViewer.this.diagramCombo.getSelectionIndex();
                PhotometricDiagramViewer.this.chartCanvas.setDiagramSelected(PhotometricDiagramViewer.this.selectedDiagram);
                PhotometricDiagramViewer.this.chartCanvas.redraw();
            }
        });
        data = new FormData();
        data.top = new FormAttachment((Control)this.chartCanvas);
        data.left = new FormAttachment(5);
        this.diagramCombo.setLayoutData((Object)data);
        this.lampCombo = new Combo((Composite)this, 12);
        this.lampCombo.select(this.selectedLamp);
        this.lampCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PhotometricDiagramViewer.this.selectedLamp = PhotometricDiagramViewer.this.lampCombo.getSelectionIndex();
                PhotometricDiagramViewer.this.chartCanvas.setLampSelected(PhotometricDiagramViewer.this.selectedLamp);
                PhotometricDiagramViewer.this.chartCanvas.redraw();
            }

            public void widgetSelected(SelectionEvent e) {
                PhotometricDiagramViewer.this.selectedLamp = PhotometricDiagramViewer.this.lampCombo.getSelectionIndex();
                PhotometricDiagramViewer.this.chartCanvas.setLampSelected(PhotometricDiagramViewer.this.selectedLamp);
                PhotometricDiagramViewer.this.chartCanvas.redraw();
            }
        });
        data = new FormData();
        data.top = new FormAttachment((Control)this.diagramCombo);
        data.left = new FormAttachment(5);
        this.lampCombo.setLayoutData((Object)data);
        FormData formData = data;
        synchronized (formData) {
            if (writerNames == null) {
                String[] temp = ImageIO.getWriterFormatNames();
                String[] special = new String[]{};
                writerNames = new String[temp.length + special.length];
                System.arraycopy(special, 0, writerNames, 0, special.length);
                System.arraycopy(temp, 0, writerNames, special.length, temp.length);
            }
        }
        this.formatCombo = new Combo((Composite)this, 12);
        String[] stringArray = writerNames;
        int n = writerNames.length;
        int temp = 0;
        while (temp < n) {
            String writerName = stringArray[temp];
            this.formatCombo.add(writerName);
            ++temp;
        }
        this.formatCombo.select(0);
        this.formatCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        data = new FormData();
        data.top = new FormAttachment((Control)this.chartCanvas);
        data.left = new FormAttachment((Control)this.diagramCombo);
        this.formatCombo.setLayoutData((Object)data);
        Button save = new Button((Composite)this, 0);
        save.setText("Save diagram as...");
        save.addMouseListener(new MouseListener(){
            boolean open = false;
            private final String[] typeSuffix = new String[]{"-illum", "-cone", "-emergency"};

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (this.open) {
                    return;
                }
                try {
                    String formatExtension = writerNames[PhotometricDiagramViewer.this.formatCombo.getSelectionIndex()];
                    String name = PhotometricDiagramViewer.unquote(PhotometricDiagramViewer.this.eulumdat.getFileName()) + this.typeSuffix[PhotometricDiagramViewer.this.chartCanvas.getDiagramSelected()] + "." + formatExtension;
                    String home = Platform.getInstanceLocation().getURL().toString();
                    FileDialog saveas = new FileDialog(PhotometricDiagramViewer.this.getShell(), 8192);
                    saveas.setFileName(name);
                    saveas.setFilterPath(home);
                    this.open = true;
                    String result = saveas.open();
                    if (result != null) {
                        this.open = false;
                        File outputfile = new File(result);
                        if (outputfile.createNewFile() && Platform.inDevelopmentMode()) {
                            Logger.logInfo("Created " + result);
                        }
                        BufferedImage bi = PhotometricDiagramViewer.this.chartCanvas.getBufferedImage(600, 600);
                        ImageIO.write((RenderedImage)bi, formatExtension, outputfile);
                        if (Platform.inDevelopmentMode()) {
                            Logger.logInfo("Saved image as " + outputfile.getAbsolutePath());
                        }
                    }
                }
                catch (IOException err) {
                    Logger.logError("Cannot save image", err);
                }
                this.open = false;
            }
        });
        Button copy = new Button((Composite)this, 0);
        copy.setText("Copy diagram");
        copy.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                BufferedImage bi = PhotometricDiagramViewer.this.chartCanvas.getBufferedImage(600, 600);
                PNGImage png = new PNGImage(bi);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(png, null);
            }
        });
        data = new FormData();
        data.top = new FormAttachment((Control)this.chartCanvas);
        data.left = new FormAttachment((Control)this.formatCombo);
        save.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.chartCanvas);
        data.left = new FormAttachment((Control)save);
        copy.setLayoutData((Object)data);
        this.chartCanvas.redraw();
    }

    private void initLampCombo() {
        this.lampCombo.removeAll();
        if (this.eulumdat != null) {
            int i = 0;
            while (i < this.eulumdat.getNumberOfLampSets()) {
                int mult = this.eulumdat.isAbsolute() ? -1 : 1;
                String lamp = mult * this.eulumdat.getLampSet(i).getAantal() + " x " + this.eulumdat.getLampSet(i).getType();
                this.lampCombo.add(lamp);
                ++i;
            }
            this.lampCombo.select(this.selectedLamp);
            this.chartCanvas.setLampSelected(this.selectedLamp);
        }
        this.lampCombo.pack(true);
        this.lampCombo.update();
    }

    public void dispose() {
        super.dispose();
        this.chartCanvas.dispose();
    }

    public Eulumdat2 getEulumdat() {
        return this.eulumdat;
    }

    public void setEulumdat(Eulumdat2 eulumdat) {
        this.eulumdat = eulumdat;
        this.chartCanvas.setEulumdat(eulumdat);
        this.initLampCombo();
        this.chartCanvas.redraw();
    }

    @Override
    public void preferenceChanged(String pref) {
        if ("BgColor".equals(pref) || "TextColor".equals(pref) || "AxisColor".equals(pref) || "TextFont".equals(pref) || "C0C180Color".equals(pref) || "C90C270Color".equals(pref) || "EmergencyColor".equals(pref) || "AllColors".equals(pref)) {
            this.readDiagramPrefs();
            this.chartCanvas.redraw();
        }
    }

    private void readDiagramPrefs() {
        IPreferenceStore store = EulumdatToolsActivator.getDefault().getPreferenceStore();
        RGB temp = PreferenceConverter.getColor((IPreferenceStore)store, (String)"BgColor");
        Color backGroundColor = new Color(PhotometricDiagramViewer.tf(temp.red), PhotometricDiagramViewer.tf(temp.green), PhotometricDiagramViewer.tf(temp.blue), 1.0f);
        this.chartCanvas.setBackGroundColor(backGroundColor);
        temp = PreferenceConverter.getColor((IPreferenceStore)store, (String)"TextColor");
        Color textColor = new Color(PhotometricDiagramViewer.tf(temp.red), PhotometricDiagramViewer.tf(temp.green), PhotometricDiagramViewer.tf(temp.blue), 1.0f);
        this.chartCanvas.setTextColor(textColor);
        temp = PreferenceConverter.getColor((IPreferenceStore)store, (String)"AxisColor");
        Color axisColor = new Color(PhotometricDiagramViewer.tf(temp.red), PhotometricDiagramViewer.tf(temp.green), PhotometricDiagramViewer.tf(temp.blue), 1.0f);
        this.chartCanvas.setAxisColor(axisColor);
        temp = PreferenceConverter.getColor((IPreferenceStore)store, (String)"C0C180Color");
        Color planeC0C180Color = new Color(PhotometricDiagramViewer.tf(temp.red), PhotometricDiagramViewer.tf(temp.green), PhotometricDiagramViewer.tf(temp.blue), 0.5f);
        this.chartCanvas.setPlaneC0C180Color(planeC0C180Color);
        temp = PreferenceConverter.getColor((IPreferenceStore)store, (String)"C90C270Color");
        Color planeC90C270Color = new Color(PhotometricDiagramViewer.tf(temp.red), PhotometricDiagramViewer.tf(temp.green), PhotometricDiagramViewer.tf(temp.blue), 0.5f);
        this.chartCanvas.setPlaneC90C270Color(planeC90C270Color);
        temp = PreferenceConverter.getColor((IPreferenceStore)store, (String)"EmergencyColor");
        Color emergencyColor = new Color(PhotometricDiagramViewer.tf(temp.red), PhotometricDiagramViewer.tf(temp.green), PhotometricDiagramViewer.tf(temp.blue), 0.5f);
        this.chartCanvas.setEmergencyColor(emergencyColor);
        FontData data = PreferenceConverter.getFontData((IPreferenceStore)store, (String)"TextFont");
        String fontName = data.getName();
        this.chartCanvas.setFontName(fontName);
    }

    private static float tf(int weight) {
        return (float)weight / 255.0f;
    }
}

