/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.graph;

import com.fold1.data.Eulumdat2;
import com.fold1.eulumdat.tools.editors.graph.PhotometricJava2dDiagram;
import com.fold1.eulumdat.tools.log.Logger;
import java.awt.Polygon;

public class CGammaDrawer {
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private int[] xPointsC0;
    private int[] xPointsC180;
    private int[] xPointsC270;
    private int[] xPointsC90;
    private int[] yPointsC0;
    private int[] yPointsC180;
    private int[] yPointsC270;
    private int[] yPointsC90;

    public CGammaDrawer(Eulumdat2 eulumdat) {
        this.init(eulumdat);
    }

    void dispose() {
        this.xPointsC0 = null;
        this.yPointsC0 = null;
        this.xPointsC90 = null;
        this.yPointsC90 = null;
        this.xPointsC180 = null;
        this.yPointsC180 = null;
        this.xPointsC270 = null;
        this.yPointsC270 = null;
    }

    public Polygon getC0C180Polygon() {
        int[] xp = PhotometricJava2dDiagram.append(this.xPointsC0, PhotometricJava2dDiagram.reversed(this.xPointsC180));
        int[] yp = PhotometricJava2dDiagram.append(this.yPointsC0, PhotometricJava2dDiagram.reversed(this.yPointsC180));
        return new Polygon(xp, yp, xp.length);
    }

    public Polygon getC90C270Polygon() {
        int[] xp = PhotometricJava2dDiagram.append(this.xPointsC90, PhotometricJava2dDiagram.reversed(this.xPointsC270));
        int[] yp = PhotometricJava2dDiagram.append(this.yPointsC90, PhotometricJava2dDiagram.reversed(this.yPointsC270));
        return new Polygon(xp, yp, xp.length);
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getScale() {
        double h;
        double w = this.getScaleX();
        return w > (h = this.getScaleY()) ? w : h;
    }

    public double getScaleStep(double scaleStart) {
        double newScale = scaleStart;
        while (true) {
            if (this.getScale() / newScale > 8.0) {
                newScale *= 2.0;
            } else {
                return newScale;
            }
            if (this.getScale() / newScale > 8.0) {
                newScale *= 2.0;
            } else {
                return newScale;
            }
            if (!(this.getScale() / newScale > 8.0)) break;
            newScale *= 2.5;
        }
        return newScale;
    }

    public double getScaleX() {
        return this.maxX - this.minX;
    }

    public double getScaleY() {
        return this.maxY - this.minY;
    }

    private void init(Eulumdat2 eulumdat) {
        this.xPointsC0 = new int[eulumdat.getNg()];
        this.yPointsC0 = new int[eulumdat.getNg()];
        this.xPointsC90 = new int[eulumdat.getNg()];
        this.yPointsC90 = new int[eulumdat.getNg()];
        this.xPointsC180 = new int[eulumdat.getNg()];
        this.yPointsC180 = new int[eulumdat.getNg()];
        this.xPointsC270 = new int[eulumdat.getNg()];
        this.yPointsC270 = new int[eulumdat.getNg()];
        int i = 0;
        while (i < this.xPointsC0.length) {
            try {
                double gamma = eulumdat.getAngleGamma(i) * (Math.PI / 180);
                double intensity = eulumdat.getIntensity(0.0, gamma);
                this.xPointsC0[i] = this.minmaxX(-intensity * Math.sin(gamma));
                this.yPointsC0[i] = this.minmaxY(intensity * Math.cos(gamma));
                intensity = eulumdat.getIntensity(Math.PI, gamma);
                this.xPointsC180[i] = this.minmaxX(intensity * Math.sin(gamma));
                this.yPointsC180[i] = this.minmaxY(intensity * Math.cos(gamma));
                intensity = eulumdat.getIntensity(1.5707963267948966, gamma);
                this.xPointsC90[i] = this.minmaxX(-intensity * Math.sin(gamma));
                this.yPointsC90[i] = this.minmaxY(intensity * Math.cos(gamma));
                intensity = eulumdat.getIntensity(4.71238898038469, gamma);
                this.xPointsC270[i] = this.minmaxX(intensity * Math.sin(gamma));
                this.yPointsC270[i] = this.minmaxY(intensity * Math.cos(gamma));
            }
            catch (IllegalArgumentException e) {
                Logger.logError("Ilegal arguments drawing CGamma", e);
            }
            ++i;
        }
    }

    private int minmaxX(double i) {
        if (i < this.minX) {
            this.minX = i;
        }
        if (i > this.maxX) {
            this.maxX = i;
        }
        return (int)i;
    }

    private int minmaxY(double i) {
        if (i < this.minY) {
            this.minY = i;
        }
        if (i > this.maxY) {
            this.maxY = i;
        }
        return (int)i;
    }
}

