/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.graph;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import swtgraphics2d.Graphics2DRenderer;

public abstract class AbstractJava2DDiagram
extends Composite {
    private static final int DEFAULTWIDTH = 600;
    private static final int DEFAULTHEIGHT = 600;
    private Graphics2DRenderer renderer = null;
    private Graphics2D g2d = null;
    protected int saveWidth = 600;
    protected int saveHeight = 600;

    public AbstractJava2DDiagram(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(e -> {
            Point controlSize = ((Control)e.getSource()).getSize();
            GC gc = e.gc;
            this.renderer = new Graphics2DRenderer();
            try {
                try {
                    this.renderer.prepareRendering(gc);
                    this.g2d = this.renderer.getGraphics2D();
                    this.awtPaint(this.g2d, controlSize.x, controlSize.y);
                    this.renderer.render(gc);
                }
                catch (NullPointerException nullPointerException) {
                    this.renderer.dispose();
                }
            }
            finally {
                this.renderer.dispose();
            }
        });
    }

    public BufferedImage getBufferedImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D temp = this.g2d;
        this.g2d = (Graphics2D)image.getGraphics();
        this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.awtPaint(this.g2d, width, height);
        this.g2d = temp;
        return image;
    }

    public abstract void awtPaint(Graphics2D var1, int var2, int var3);

    public void dispose() {
        super.dispose();
        if (this.renderer != null) {
            this.renderer.dispose();
        }
    }

    public int getSaveHeight() {
        return this.saveHeight;
    }

    public void setSaveHeight(int saveHeight) {
        this.saveHeight = saveHeight;
    }

    public int getSaveWidth() {
        return this.saveWidth;
    }

    public void setSaveWidth(int saveWidth) {
        this.saveWidth = saveWidth;
    }
}

