/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat.text;

import com.fold1.eulumdat.tools.editors.converter.text.LegalLampAssistProcessor;
import com.fold1.eulumdat.tools.editors.eulumdat.text.EulumdatAnnotationHover;
import com.fold1.eulumdat.tools.editors.eulumdat.text.EulumdatFloatScanner;
import com.fold1.eulumdat.tools.editors.eulumdat.text.EulumdatIntegerScanner;
import com.fold1.eulumdat.tools.editors.eulumdat.text.EulumdatLampScanner;
import com.fold1.eulumdat.tools.editors.eulumdat.text.EulumdatScanner;
import com.fold1.eulumdat.tools.editors.eulumdat.text.EulumdatTextEditorColorManager;
import com.fold1.eulumdat.tools.lamps.ILampSuggester;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class EulumdatSourceViewerConfig
extends TextSourceViewerConfiguration {
    private static final int AUTOACTIVATION_DELAY = 5;
    private EulumdatScanner scanner;
    private EulumdatLampScanner lampscanner;
    private EulumdatFloatScanner floatscanner;
    private final ILampSuggester suggester;
    private final EulumdatTextEditorColorManager colorManager;
    private EulumdatIntegerScanner intscanner;

    public EulumdatSourceViewerConfig(IPreferenceStore iPreferenceStore, EulumdatTextEditorColorManager colorManager2, ILampSuggester suggester) {
        super(iPreferenceStore);
        this.colorManager = colorManager2;
        this.suggester = suggester;
    }

    private ITokenScanner getTextScanner() {
        if (this.scanner == null) {
            this.scanner = new EulumdatScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getTextColor())));
        }
        return this.scanner;
    }

    private ITokenScanner getLampScanner() {
        if (this.lampscanner == null) {
            this.lampscanner = new EulumdatLampScanner(this.colorManager);
            this.lampscanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getLampTextColor())));
        }
        return this.lampscanner;
    }

    private ITokenScanner getFloatScanner() {
        if (this.floatscanner == null) {
            this.floatscanner = new EulumdatFloatScanner(this.colorManager);
            this.floatscanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getExtraWhitespaceTextColor())));
        }
        return this.floatscanner;
    }

    private ITokenScanner getIntegerScanner() {
        if (this.intscanner == null) {
            this.intscanner = new EulumdatIntegerScanner(this.colorManager);
            this.intscanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getExtraWhitespaceTextColor())));
        }
        return this.intscanner;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (RegistrationController.isOKToUse(false)) {
            return new String[]{"__dftl_partition_content_type", "__float", "__integer", "__lamptype", "__text"};
        }
        return new String[]{"__dftl_partition_content_type"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceView) {
        if (!RegistrationController.isOKToUse(false)) {
            return null;
        }
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getLampScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__lamptype");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lamptype");
        dr = new DefaultDamagerRepairer(this.getTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__text");
        reconciler.setRepairer((IPresentationRepairer)dr, "__text");
        dr = new DefaultDamagerRepairer(this.getFloatScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__float");
        reconciler.setRepairer((IPresentationRepairer)dr, "__float");
        dr = new DefaultDamagerRepairer(this.getIntegerScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__integer");
        reconciler.setRepairer((IPresentationRepairer)dr, "__integer");
        dr = new DefaultDamagerRepairer(this.getLampScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer viewer) {
        if (!RegistrationController.isOKToUse(true)) {
            return null;
        }
        if (this.suggester == null && viewer.isEditable()) {
            return null;
        }
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new LegalLampAssistProcessor(this.suggester), "__lamptype");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(5);
        assistant.setProposalPopupOrientation(10);
        return assistant;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new EulumdatAnnotationHover();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new DefaultTextHover(sourceViewer);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] hyperlinkDetectors = super.getHyperlinkDetectors(sourceViewer);
        return hyperlinkDetectors;
    }
}

