/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat.text;

import com.fold1.eulumdat.tools.log.Logger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class EulumdatPartitionScanner
implements IPartitionTokenScanner {
    public static final String FLOAT = "__float";
    public static final String INTEGER = "__integer";
    public static final String LAMPTYPE = "__lamptype";
    public static final String TEXT = "__text";
    private IDocument document;
    private final IToken floatToken;
    private final IToken integerToken;
    private final IToken lamptypeToken;
    private int nrofpartitions;
    private int numberOfLampSets;
    private List<Partition> partitions;
    private int startOffset;
    private final IToken textToken = new Token((Object)"__text");
    private int tokenIndex;

    public EulumdatPartitionScanner() {
        this.lamptypeToken = new Token((Object)LAMPTYPE);
        this.integerToken = new Token((Object)INTEGER);
        this.floatToken = new Token((Object)FLOAT);
    }

    private Partition createPartition(int startline, int lastline, IToken type) {
        try {
            int offset = this.document.getLineOffset(startline);
            int length = this.document.getLineOffset(lastline) - this.document.getLineOffset(startline) + this.document.getLineLength(lastline);
            return new Partition(offset, length, type);
        }
        catch (BadLocationException e) {
            Logger.logError("Cannot create partition for line " + startline + " to " + lastline, e);
            return null;
        }
    }

    private Partition createPartition(int line, IToken type) {
        try {
            int offset = this.document.getLineOffset(line);
            int length = this.document.getLineLength(line);
            return new Partition(offset, length, type);
        }
        catch (BadLocationException e) {
            Logger.logError("Cannot create partition for line " + (line + 1), e);
            return null;
        }
    }

    private void getNumberOfLampSets() {
        try {
            String noflsLine = this.document.get(this.document.getLineOffset(25), this.document.getLineLength(25));
            this.numberOfLampSets = Integer.parseInt(noflsLine.trim());
        }
        catch (NumberFormatException e) {
            Logger.logError("Cannot read number of lamp sets", e);
        }
        catch (BadLocationException e) {
            Logger.logError("Line for number of lamp sets not found", e);
        }
    }

    public int getTokenLength() {
        if (this.tokenIndex >= this.nrofpartitions) {
            return 0;
        }
        return this.partitions.get(this.tokenIndex).getLength();
    }

    public int getTokenOffset() {
        if (this.tokenIndex >= this.nrofpartitions) {
            return this.startOffset;
        }
        return this.partitions.get(this.tokenIndex).getStart();
    }

    public IToken nextToken() {
        ++this.tokenIndex;
        if (this.tokenIndex >= this.nrofpartitions) {
            return Token.EOF;
        }
        Partition partition = this.partitions.get(this.tokenIndex);
        if (partition == null) {
            return Token.UNDEFINED;
        }
        return partition.getToken();
    }

    private ArrayList<Partition> partitionEulumdat(int offset, int documentLength) {
        ArrayList<Partition> partitionlist = new ArrayList<Partition>();
        this.nrofpartitions = 0;
        this.getNumberOfLampSets();
        try {
            int startline = this.document.getLineOfOffset(offset);
            if (startline <= 0) {
                partitionlist.add(this.createPartition(0, this.textToken));
            }
            if (startline <= 3) {
                partitionlist.add(this.createPartition(1, 3, this.integerToken));
            }
            if (startline <= 4) {
                partitionlist.add(this.createPartition(4, this.floatToken));
            }
            if (startline <= 5) {
                partitionlist.add(this.createPartition(5, this.integerToken));
            }
            if (startline <= 6) {
                partitionlist.add(this.createPartition(6, this.floatToken));
            }
            if (startline <= 11) {
                partitionlist.add(this.createPartition(7, 11, this.textToken));
            }
            if (startline <= 24) {
                partitionlist.add(this.createPartition(12, 24, this.floatToken));
            }
            if (startline <= 25) {
                partitionlist.add(this.createPartition(25, this.integerToken));
            }
            int i = 0;
            while (i < this.numberOfLampSets) {
                if (startline <= 26 + i * 6) {
                    partitionlist.add(this.createPartition(26 + i * 6, this.integerToken));
                }
                if (startline <= 27 + i * 6) {
                    partitionlist.add(this.createPartition(27 + i * 6, this.lamptypeToken));
                }
                if (startline <= 28 + i * 6) {
                    partitionlist.add(this.createPartition(28 + i * 6, this.floatToken));
                }
                if (startline <= 30 + i * 6) {
                    partitionlist.add(this.createPartition(29 + i * 6, 30 + i * 6, this.textToken));
                }
                if (startline <= 31 + i * 6) {
                    partitionlist.add(this.createPartition(31 + i * 6, this.floatToken));
                }
                ++i;
            }
            partitionlist.add(this.createPartition(26 + this.numberOfLampSets * 6, this.document.getNumberOfLines() - 1, this.floatToken));
            return partitionlist;
        }
        catch (BadLocationException e) {
            Logger.logError("Partitioning error", e);
            return partitionlist;
        }
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.document = document;
        this.partitions = this.partitionEulumdat(offset, document.getLength());
        try {
            this.verify(this.partitions, offset);
        }
        catch (BadLocationException e) {
            Logger.logError("Verify failed", e);
        }
        this.tokenIndex = -1;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.startOffset = offset;
        this.partitions = this.partitionEulumdat(offset, length);
        try {
            this.verify(this.partitions, offset);
        }
        catch (BadLocationException e) {
            Logger.logError("Verify failed", e);
        }
        this.tokenIndex = -1;
    }

    private void verify(List<Partition> partitions2, int start) throws BadLocationException {
        int predicted = this.document.getPartition(start).getOffset();
        for (Partition p : partitions2) {
            Assert.isTrue((predicted == p.getStart() ? 1 : 0) != 0, (String)("start = " + p.getStart()));
            predicted += p.getLength();
        }
        Assert.isTrue((predicted == this.document.getLength() ? 1 : 0) != 0, (String)"document length");
    }

    private class Partition {
        private int length;
        private int start;
        private IToken token;

        private Partition() {
        }

        Partition(int start, int length, IToken token) {
            this.start = start;
            this.length = length;
            this.token = token;
            ++EulumdatPartitionScanner.this.nrofpartitions;
        }

        public int getLength() {
            return this.length;
        }

        public int getStart() {
            return this.start;
        }

        public IToken getToken() {
            return this.token;
        }

        public String getTokenVal() {
            return (String)this.token.getData();
        }
    }
}

