/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat.text;

import com.fold1.eulumdat.tools.log.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class EulumdatAnnotationHover
implements IAnnotationHover {
    public String getHoverInfo(ISourceViewer viewer, int lineNumber) {
        List<IMarker> annotations = EulumdatAnnotationHover.getAnnotations(viewer, lineNumber);
        return EulumdatAnnotationHover.printAnnotations(annotations);
    }

    private static List<IMarker> getAnnotations(ISourceViewer viewer, int lineNumber) {
        IAnnotationModel model = viewer.getAnnotationModel();
        IDocument document = viewer.getDocument();
        return EulumdatAnnotationHover.getAnnotationsAtLine(model, document, lineNumber);
    }

    private static List<IMarker> getAnnotationsAtLine(IAnnotationModel model, IDocument document, int lineNumber) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        Iterator i = model.getAnnotationIterator();
        while (i.hasNext()) {
            MarkerAnnotation annot;
            IMarker marker;
            Object o = i.next();
            if (!(o instanceof MarkerAnnotation) || lineNumber + 1 != (marker = (annot = (MarkerAnnotation)o).getMarker()).getAttribute("lineNumber", 0)) continue;
            markers.add(marker);
        }
        return markers;
    }

    private static String printAnnotations(List<IMarker> annotations) {
        StringBuffer sb = new StringBuffer();
        Iterator<IMarker> i = annotations.iterator();
        while (i.hasNext()) {
            IMarker marker = i.next();
            try {
                sb.append(marker.getAttribute("message"));
                if (!i.hasNext()) continue;
                sb.append("\n");
            }
            catch (CoreException e) {
                Logger.logError("Error printing annotations", e);
            }
        }
        return sb.toString();
    }
}

