/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat;

import com.fold1.data.LampSet;
import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatEditor;
import com.fold1.eulumdat.tools.editors.eulumdat.LuminaireFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class RemoveLampAction
extends Action {
    EulumdatEditor editor;
    private final TableViewer viewer;
    private final ISelectionChangedListener listener = event -> {
        ISelection sel = event.getSelection();
        int combinations = this.editor.eulumdat.getNumberOfLampSets();
        if (combinations == 1) {
            this.setEnabled(false);
        } else if (event.getSelection().isEmpty()) {
            this.setEnabled(false);
        } else if (this.getLampIndex(sel, combinations) >= 0) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    };

    private int getLampIndex(ISelection sel, int combinations) {
        LuminaireFeature first;
        int line;
        Object element = ((IStructuredSelection)sel).getFirstElement();
        if (element instanceof LuminaireFeature && (line = (first = (LuminaireFeature)element).getLine()) > 26 && line < 27 + combinations * 6) {
            return (line - 27) / 6;
        }
        if (element instanceof LampSet) {
            int i = this.editor.eulumdat.getNumberOfLampSets() - 1;
            while (i >= 0) {
                if (element.equals(this.editor.eulumdat.getLampSet(i))) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public RemoveLampAction(EulumdatEditor editor, TableViewer viewer, String text, ImageDescriptor image) {
        super(text, image);
        this.editor = editor;
        this.viewer = viewer;
        this.setEnabled(false);
        viewer.addSelectionChangedListener(this.listener);
    }

    public void run() {
        ISelection sel = this.viewer.getSelection();
        int target = this.getLampIndex(sel, this.editor.eulumdat.getNumberOfLampSets());
        this.editor.eulumdat.removeLamp(target);
        this.editor.eulumdatChanged(26);
    }
}

