/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat;

import com.fold1.data.LampSet;
import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatEditor;
import com.fold1.eulumdat.tools.editors.eulumdat.LuminaireFeature;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class LuminaireEditorCellModifier
implements ICellModifier {
    private final EulumdatEditor editor;

    public LuminaireEditorCellModifier(EulumdatEditor editor) {
        this.editor = editor;
    }

    public boolean canModify(Object element, String property) {
        if ("values".equals(property) && element instanceof LuminaireFeature) {
            return ((LuminaireFeature)element).isEditable();
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if ("values".equals(property) && element instanceof LuminaireFeature) {
            return ((LuminaireFeature)element).getValue();
        }
        return null;
    }

    public void modify(Object item, String property, Object value) {
        if (value == null) {
            return;
        }
        if ("values".equals(property) && item instanceof TableItem) {
            double doublevalue;
            Object element = ((TableItem)item).getData();
            String text = ((String)value).trim();
            try {
                doublevalue = Double.parseDouble(text.replace(',', '.'));
            }
            catch (NumberFormatException e) {
                doublevalue = 0.0;
            }
            if (element instanceof LuminaireFeature) {
                LuminaireFeature feature = (LuminaireFeature)element;
                int line = feature.getLine();
                switch (line) {
                    case 1: {
                        this.editor.eulumdat.setProductBrand(text);
                        break;
                    }
                    case 8: {
                        this.editor.eulumdat.setProtocol(text);
                        break;
                    }
                    case 9: {
                        this.editor.eulumdat.setProductName(text);
                        break;
                    }
                    case 10: {
                        this.editor.eulumdat.setProductCode(text);
                        break;
                    }
                    case 11: {
                        this.editor.eulumdat.setFileName(text);
                        break;
                    }
                    case 12: {
                        this.editor.eulumdat.setDateUser(text);
                        break;
                    }
                    case 13: {
                        this.editor.eulumdat.setLength(doublevalue);
                        break;
                    }
                    case 14: {
                        this.editor.eulumdat.setWidth(doublevalue);
                        break;
                    }
                    case 15: {
                        this.editor.eulumdat.setHeight(doublevalue);
                        break;
                    }
                    case 16: {
                        this.editor.eulumdat.setLuminousLength(doublevalue);
                        break;
                    }
                    case 17: {
                        this.editor.eulumdat.setLuminousWidth(doublevalue);
                        break;
                    }
                    case 18: {
                        this.editor.eulumdat.setLuminousHeightC0(doublevalue);
                        break;
                    }
                    case 19: {
                        this.editor.eulumdat.setLuminousHeightC90(doublevalue);
                        break;
                    }
                    case 20: {
                        this.editor.eulumdat.setLuminousHeightC180(doublevalue);
                        break;
                    }
                    case 21: {
                        this.editor.eulumdat.setLuminousHeightC270(doublevalue);
                        break;
                    }
                }
                int index = this.getLampIndex(line);
                if (index >= 0 && this.editor.eulumdat.getLampSet(index) instanceof LampSet) {
                    switch ((line - 27) % 6) {
                        case 0: {
                            this.editor.eulumdat.getLampSet(index).setAantal((int)doublevalue);
                            break;
                        }
                        case 1: {
                            this.editor.eulumdat.getLampSet(index).setType(text);
                            break;
                        }
                        case 2: {
                            this.editor.eulumdat.getLampSet(index).setTotalLumen(doublevalue);
                            break;
                        }
                        case 3: {
                            this.editor.eulumdat.getLampSet(index).setColorTemp(text);
                            break;
                        }
                        case 4: {
                            this.editor.eulumdat.getLampSet(index).setColorRendering(text);
                            break;
                        }
                        case 5: {
                            this.editor.eulumdat.getLampSet(index).setPowerUsed(doublevalue);
                            break;
                        }
                    }
                }
                this.editor.eulumdatChanged(line);
            }
        }
    }

    private int getLampIndex(int line) {
        if (line > 26 && line < 27 + this.editor.eulumdat.getNumberOfLampSets() * 6) {
            return (line - 27) / 6;
        }
        return -1;
    }
}

