/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat;

import com.fold1.data.ILampSetRO;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.util.NumberOutput;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class LampsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final int ID_INDEX = 0;
    private static final int QTY_INDEX = 1;
    private static final int TYPE_INDEX = 2;
    private static final int LUMEN_INDEX = 3;
    private static final int COLORTEMP_INDEX = 4;
    private static final int CRI_INDEX = 5;
    private static final int POWER_INDEX = 6;

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ILampSetRO) {
            ILampSetRO lamp = (ILampSetRO)element;
            switch (columnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    int mult = lamp.getAantal() < 0 ? -1 : 1;
                    return Integer.toString(mult * lamp.getAantal());
                }
                case 2: {
                    return lamp.getType();
                }
                case 3: {
                    return NumberOutput.localDigits((double)lamp.getTotalLumen(), (int)0);
                }
                case 4: {
                    return lamp.getColorTemp();
                }
                case 5: {
                    return lamp.getColorRendering();
                }
                case 6: {
                    return NumberOutput.localDigits((double)lamp.getPowerUsed(), (int)2);
                }
                default: {
                    Logger.logError("Illegal Lamp Index", new IllegalStateException());
                }
            }
        }
        return null;
    }
}

