/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat;

import com.fold1.data.ILampSet;
import com.fold1.data.ILampSetRO;
import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatEditor;
import com.fold1.util.NumberOutput;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class LampsEditorCellModifier
implements ICellModifier {
    EulumdatEditor editor;

    public LampsEditorCellModifier(EulumdatEditor editor) {
        this.editor = editor;
    }

    public boolean canModify(Object element, String property) {
        if (element instanceof ILampSet) {
            return !property.equals("lampID");
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof ILampSetRO) {
            if (property.equals("lampQty")) {
                return NumberOutput.localDigits((double)((ILampSetRO)element).getAantal(), (int)0);
            }
            if (property.equals("lampType")) {
                return ((ILampSetRO)element).getType();
            }
            if (property.equals("lampLumen")) {
                return NumberOutput.localDigits((double)((ILampSetRO)element).getTotalLumen(), (int)0);
            }
            if (property.equals("lampColorTemp")) {
                return ((ILampSetRO)element).getColorTemp();
            }
            if (property.equals("lampCri")) {
                return ((ILampSetRO)element).getColorRendering();
            }
            if (property.equals("lampWattage")) {
                return NumberOutput.localDigits((double)((ILampSetRO)element).getPowerUsed(), (int)1);
            }
        }
        return null;
    }

    public void modify(Object item, String property, Object value) {
        Object element = ((TableItem)item).getData();
        String text = ((String)value).trim();
        if (this.getValue(element, property).equals(value)) {
            return;
        }
        if (element instanceof ILampSet) {
            if (property.equals("lampQty")) {
                ((ILampSet)element).setAantal((int)LampsEditorCellModifier.getSafeDouble(text));
            }
            if (property.equals("lampType")) {
                ((ILampSet)element).setType(text.trim());
            }
            if (property.equals("lampLumen")) {
                ((ILampSet)element).setTotalLumen(LampsEditorCellModifier.getSafeDouble(text));
            }
            if (property.equals("lampColorTemp")) {
                ((ILampSet)element).setColorTemp(text.trim());
            }
            if (property.equals("lampCri")) {
                ((ILampSet)element).setColorRendering(text.trim());
            }
            if (property.equals("lampWattage")) {
                ((ILampSet)element).setPowerUsed(LampsEditorCellModifier.getSafeDouble(text));
            }
            this.editor.eulumdatChanged(26);
        }
    }

    private static double getSafeDouble(String text) {
        double doublevalue;
        try {
            doublevalue = Double.parseDouble(text.replace(',', '.'));
        }
        catch (NumberFormatException e) {
            doublevalue = 0.0;
        }
        return doublevalue;
    }
}

