/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat;

import com.fold1.data.Eulumdat2;
import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatOutlineContentProvider;
import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatOutlineLabelProvider;
import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatTextEditor;
import com.fold1.eulumdat.tools.editors.eulumdat.LuminaireFeature;
import com.fold1.eulumdat.tools.log.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class EulumdatOutlinePage
extends ContentOutlinePage {
    private final EulumdatTextEditor editor;
    private boolean flag;

    public EulumdatOutlinePage(EulumdatTextEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer outlineTreeViewer = this.getTreeViewer();
        if (outlineTreeViewer != null) {
            outlineTreeViewer.setContentProvider((IContentProvider)new EulumdatOutlineContentProvider());
            outlineTreeViewer.setLabelProvider((IBaseLabelProvider)new EulumdatOutlineLabelProvider());
            this.startEditorListening();
        } else {
            Logger.logError("no outlineTreeViewer created!", new Exception());
        }
    }

    public void dispose() {
        this.stopEditorListening();
        super.dispose();
    }

    private void stopEditorListening() {
        this.editor.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void startEditorListening() {
        this.editor.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void setInput(Eulumdat2 eulumdat) {
        TreeViewer outlineTreeViewer = this.getTreeViewer();
        if (outlineTreeViewer != null) {
            outlineTreeViewer.setInput((Object)eulumdat);
        } else {
            Logger.logError("no outlineTreeViewer found!", new Exception());
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        if (event.getSource() instanceof SourceViewer) {
            this.flag = false;
            this.updateOutlineSelection(event);
            this.flag = true;
        } else if (this.flag && event.getSource() instanceof TreeViewer) {
            this.updateEditorSelection(event);
        }
    }

    private void updateEditorSelection(SelectionChangedEvent event) {
        IDocument document = this.getDocument();
        Assert.isNotNull((Object)document);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.editor.resetHighlightRange();
        } else {
            IStructuredSelection sel = (IStructuredSelection)selection;
            int indexOfLast = sel.size() - 1;
            LuminaireFeature first = (LuminaireFeature)sel.getFirstElement();
            LuminaireFeature last = (LuminaireFeature)sel.toList().get(indexOfLast);
            try {
                int start = document.getLineOffset(first.getLine() - 1);
                int length = document.getLineOffset(last.getLine() - 1) + document.getLineLength(last.getLine() - 1) - start;
                this.editor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException | BadLocationException e) {
                Logger.logError("Problem with outline selection", e);
                this.editor.resetHighlightRange();
            }
        }
    }

    private IDocument getDocument() {
        return this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
    }

    private void updateOutlineSelection(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.handleSelectionChanged(selection);
    }

    private void handleSelectionChanged(ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            int first = textSelection.getStartLine() + 1;
            int last = textSelection.getEndLine() + 1;
            Object[] items = this.getOutlineContentProvider().getItemsToSelect(first, last);
            StructuredSelection sel = new StructuredSelection(items);
            this.getTreeViewer().setSelection((ISelection)sel, true);
            return;
        }
    }

    private EulumdatOutlineContentProvider getOutlineContentProvider() {
        return (EulumdatOutlineContentProvider)this.getTreeViewer().getContentProvider();
    }
}

