/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat;

import com.fold1.data.Eulumdat2;
import com.fold1.data.RoomIndex;
import com.fold1.eulumdat.tools.editors.eulumdat.LuminaireFeature;
import com.fold1.util.NumberOutput;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class EulumdatOutlineContentProvider
implements ITreeContentProvider {
    private static final String LAMP = "Lamp [ ";
    ArrayList<LuminaireFeature> luminaireFeatures;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof Eulumdat2;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Eulumdat2) {
            return this.fillLuminaireFeatures((Eulumdat2)inputElement).toArray();
        }
        return new Object[0];
    }

    public Object[] getItemsToSelect(int first, int last) {
        ArrayList<LuminaireFeature> itemsToSelect = new ArrayList<LuminaireFeature>();
        if (this.luminaireFeatures == null) {
            return new Object[0];
        }
        for (LuminaireFeature feature : this.luminaireFeatures) {
            if (feature.getLine() < first || feature.getLine() > last) continue;
            itemsToSelect.add(feature);
        }
        return itemsToSelect.toArray();
    }

    private ArrayList<LuminaireFeature> fillLuminaireFeatures(Eulumdat2 eulumdat) {
        this.luminaireFeatures = new ArrayList();
        if (eulumdat != null) {
            this.addEulumdatItem("Manufacturer", eulumdat.getProductBrand(), 1, true);
            this.addEulumdatItem("Type of Source", eulumdat.getItyp().toString(), 2, false);
            this.addEulumdatItem("Symmetry", eulumdat.getIsym().toString(), 3, false);
            this.addEulumdatItem("Number of C-planes", NumberOutput.localDigits((double)eulumdat.getNoCPlanes(), (int)0), 4, false);
            this.addEulumdatItem("Distance between C-planes", NumberOutput.localDigits((double)eulumdat.getDc(), (int)1), 5, false);
            this.addEulumdatItem("Number of Intensities in each C-plane", NumberOutput.localDigits((double)eulumdat.getNg(), (int)0), 6, false);
            this.addEulumdatItem("Distance between Intensities", NumberOutput.localDigits((double)eulumdat.getDg(), (int)1), 7, false);
            this.addEulumdatItem("Test Report No", eulumdat.getProtocol(), 8, true);
            this.addEulumdatItem("Product Name", eulumdat.getProductName(), 9, true);
            this.addEulumdatItem("Product Code", eulumdat.getProductCode(), 10, true);
            this.addEulumdatItem("Filename", eulumdat.getFileName(), 11, true);
            this.addEulumdatItem("Date", eulumdat.getDateUser(), 12, true);
            this.addEulumdatItem("Product Length [mm]", NumberOutput.localDigits((double)eulumdat.getLength(), (int)0), 13, true);
            this.addEulumdatItem("Product Width [mm]", NumberOutput.localDigits((double)eulumdat.getWidth(), (int)0), 14, true);
            this.addEulumdatItem("Product Height [mm]", NumberOutput.localDigits((double)eulumdat.getHeight(), (int)0), 15, true);
            this.addEulumdatItem("Emit Length [mm]", NumberOutput.localDigits((double)eulumdat.getLuminousLength(), (int)0), 16, true);
            this.addEulumdatItem("Emit Width [mm]", NumberOutput.localDigits((double)eulumdat.getLuminousWidth(), (int)0), 17, true);
            this.addEulumdatItem("Emit Height C0   [mm]", NumberOutput.localDigits((double)eulumdat.getLuminousHeightC0(), (int)0), 18, true);
            this.addEulumdatItem("Emit Height C90  [mm]", NumberOutput.localDigits((double)eulumdat.getLuminousHeightC90(), (int)0), 19, true);
            this.addEulumdatItem("Emit Height C180 [mm]", NumberOutput.localDigits((double)eulumdat.getLuminousHeightC180(), (int)0), 20, true);
            this.addEulumdatItem("Emit Height C270 [mm]", NumberOutput.localDigits((double)eulumdat.getLuminousHeightC270(), (int)0), 21, true);
            this.addEulumdatItem("Downward Flux Fraction [%]", NumberOutput.localDigits((double)eulumdat.getDownwardFluxPercentage(), (int)1), 22, false);
            this.addEulumdatItem("Light Output Ratio [%]", NumberOutput.localDigits((double)eulumdat.getEfficacy(), (int)1), 23, false);
            this.addEulumdatItem("Conversion Factor", NumberOutput.localDigits((double)eulumdat.getOpticalConversionFactor(), (int)2), 24, false);
            this.addEulumdatItem("Tilt", NumberOutput.localDigits((double)eulumdat.getTilt(), (int)0), 25, false);
            this.addEulumdatItem("Nr of Lamp Options", NumberOutput.localDigits((double)eulumdat.getNumberOfLampSets(), (int)0), 26, false);
            int numberOfLamps = eulumdat.getNumberOfLampSets();
            int i = 0;
            while (i < numberOfLamps) {
                this.addEulumdatItem(LAMP + (i + 1) + " ] Nr of Lamps", NumberOutput.localDigits((double)eulumdat.getLampSetRO(i).getAantal(), (int)0), 27 + i * 6, true);
                this.addEulumdatItem(LAMP + (i + 1) + " ] Lamp Type", eulumdat.getLampSetRO(i).getType(), 28 + i * 6, true);
                this.addEulumdatItem(LAMP + (i + 1) + " ] Lamp Flux [lm]", NumberOutput.localDigits((double)eulumdat.getLampSetRO(i).getTotalLumen(), (int)0), 29 + i * 6, true);
                this.addEulumdatItem(LAMP + (i + 1) + " ] Colour Temp", eulumdat.getLampSetRO(i).getColorTemp(), 30 + i * 6, true);
                this.addEulumdatItem(LAMP + (i + 1) + " ] CRI", eulumdat.getLampSetRO(i).getColorRendering(), 31 + i * 6, true);
                this.addEulumdatItem(LAMP + (i + 1) + " ] Lamp Power [W]", NumberOutput.localDigits((double)eulumdat.getLampSetRO(i).getPowerUsed(), (int)1), 32 + i * 6, true);
                ++i;
            }
            i = 0;
            while (i < 10) {
                this.addEulumdatItem("Direct Ratio [ " + RoomIndex.getRoomFactorString((int)i) + " ]", NumberOutput.localDigits((double)eulumdat.getDirectFluxFactor(i), (int)6), 27 + 6 * numberOfLamps + i, false);
                ++i;
            }
        }
        return this.luminaireFeatures;
    }

    private void addEulumdatItem(String label, String value, int line, boolean editable) {
        this.luminaireFeatures.add(new LuminaireFeature(label, value, line, editable));
    }
}

