/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat;

import com.fold1.data.Eulumdat2;
import com.fold1.data.EulumdatFactory;
import com.fold1.data.ICGamma;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.parser.ParserFactory;
import com.fold1.eulumdat.tools.editors.eulumdat.AbstractCopyAction;
import com.fold1.eulumdat.tools.editors.eulumdat.AddLampAction;
import com.fold1.eulumdat.tools.editors.eulumdat.CGammaContentProvider;
import com.fold1.eulumdat.tools.editors.eulumdat.CGammaLabelProvider;
import com.fold1.eulumdat.tools.editors.eulumdat.CopyCGammaAction;
import com.fold1.eulumdat.tools.editors.eulumdat.CopyLuminaireAction;
import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatOutlinePage;
import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatTextEditor;
import com.fold1.eulumdat.tools.editors.eulumdat.LampsContentProvider;
import com.fold1.eulumdat.tools.editors.eulumdat.LampsEditorCellModifier;
import com.fold1.eulumdat.tools.editors.eulumdat.LampsLabelProvider;
import com.fold1.eulumdat.tools.editors.eulumdat.LuminaireContentProvider;
import com.fold1.eulumdat.tools.editors.eulumdat.LuminaireEditorCellModifier;
import com.fold1.eulumdat.tools.editors.eulumdat.LuminaireLabelProvider;
import com.fold1.eulumdat.tools.editors.eulumdat.RemoveLampAction;
import com.fold1.eulumdat.tools.editors.eulumdat.text.EulumdatDocumentProvider;
import com.fold1.eulumdat.tools.editors.graph.PhotometricDiagramViewer;
import com.fold1.eulumdat.tools.lamps.ILampSuggester;
import com.fold1.eulumdat.tools.lamps.ILampVerifier;
import com.fold1.eulumdat.tools.lamps.LampManagerPool;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import com.fold1.eulumdat.tools.utils.MenuUtils;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.exceptions.ParserException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class EulumdatEditor
extends MultiPageEditorPart
implements IGotoMarker,
IResourceChangeListener,
IPersistableEditor {
    private static final String NON_EXISTENT_PAGE = "Non existent page!";
    private static final int SOURCEPAGE = 0;
    private static final int LUMINAIREPAGE = 1;
    private static final int LAMPSPAGE = 2;
    private static final int CGAMMAPAGE = 3;
    private static final int DIAGRAMPAGE = 4;
    IFile file;
    private EulumdatTextEditor textEditor;
    private TableViewer luminaireViewer;
    private AbstractCopyAction copyLuminaireAction;
    private TableColumn labelColumn;
    private TableColumn valueColumn;
    protected static final String LABEL_COLUMN_ID = "labels";
    protected static final String VALUE_COLUMN_ID = "values";
    private RemoveLampAction removeInLuminaireAction;
    private IAction addLampAction;
    private TableViewer lampsViewer;
    protected static final String LAMPID_COLUMN_ID = "lampID";
    protected static final String LAMPQTY_COLUMN_ID = "lampQty";
    protected static final String LAMPTYPE_COLUMN_ID = "lampType";
    protected static final String LAMPLUMEN_COLUMN_ID = "lampLumen";
    protected static final String LAMPCOLORTEMP_COLUMN_ID = "lampColorTemp";
    protected static final String LAMPCRI_COLUMN_ID = "lampCri";
    protected static final String LAMPWATTAGE_COLUMN_ID = "lampWattage";
    private RemoveLampAction removeInLampsAction;
    private TableViewer cgammaViewer;
    private CopyCGammaAction copyCGammaAction;
    private PhotometricDiagramViewer diagramComposite;
    protected Eulumdat2 eulumdat;
    private EulumdatOutlinePage outlinePage;
    protected ILampSuggester suggester;
    private boolean inProject;
    private final IUndoContext eulumdatUndoContext;
    private IOperationHistory operationHistory;
    private IMemento savedMemento;

    public EulumdatEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.eulumdatUndoContext = new ObjectUndoContext((Object)this);
    }

    protected void createPages() {
        this.createLampSuggester();
        this.createSourcePage();
        this.createLuminairePage();
        this.createLuminaireActions();
        this.initLuminaireEditors();
        this.initLuminaireContent();
        this.createLuminaireContextMenu();
        this.createLampsPage();
        this.createLampsActions();
        this.initLampsEditors();
        this.initLampsContent();
        this.createLampsContextMenu();
        this.createCGammaPage();
        this.createCGammaActions();
        this.initCGammaContent();
        this.createCGammaContextMenu();
        this.createDiagramPage();
        this.initDiagramContent();
        this.createDiagramContextMenu();
        this.updateTitle();
        this.parseEulumdat();
        this.restoreFromMemento(this.savedMemento);
    }

    private void createDiagramContextMenu() {
    }

    private void initDiagramContent() {
    }

    private void initLampsEditors() {
        this.lampsViewer.setColumnProperties(new String[]{LAMPID_COLUMN_ID, LAMPQTY_COLUMN_ID, LAMPTYPE_COLUMN_ID, LAMPLUMEN_COLUMN_ID, LAMPCOLORTEMP_COLUMN_ID, LAMPCRI_COLUMN_ID, LAMPWATTAGE_COLUMN_ID});
        TextCellEditor lampsCellEditor = new TextCellEditor((Composite)this.lampsViewer.getTable());
        CellEditor[] cellEditorArray = new CellEditor[7];
        cellEditorArray[1] = lampsCellEditor;
        cellEditorArray[2] = lampsCellEditor;
        cellEditorArray[3] = lampsCellEditor;
        cellEditorArray[4] = lampsCellEditor;
        cellEditorArray[5] = lampsCellEditor;
        cellEditorArray[6] = lampsCellEditor;
        this.lampsViewer.setCellEditors(cellEditorArray);
        this.lampsViewer.setCellModifier((ICellModifier)new LampsEditorCellModifier(this));
    }

    private void initLampsContent() {
        LampsContentProvider lampContentProvider = new LampsContentProvider();
        this.lampsViewer.setContentProvider((IContentProvider)lampContentProvider);
        this.lampsViewer.setLabelProvider((IBaseLabelProvider)new LampsLabelProvider());
        this.lampsViewer.setInput((Object)this.eulumdat);
        this.lampsViewer.getTable().getDisplay().asyncExec(() -> {
            this.parseEulumdat();
            this.updateLampsFromEulumdat(this.eulumdat);
        });
    }

    private void updateLampsFromEulumdat(Eulumdat2 eu) {
        if (this.lampsViewer != null) {
            this.lampsViewer.setInput((Object)eu);
        }
    }

    private void createLampsPage() {
        this.lampsViewer = new TableViewer(this.getContainer(), 65538);
        Table table = this.lampsViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn lampIdColumn = new TableColumn(table, 0);
        lampIdColumn.setText("#");
        lampIdColumn.setWidth(50);
        TableColumn lampQtyColumn = new TableColumn(table, 0);
        lampQtyColumn.setText("Number");
        lampQtyColumn.setWidth(100);
        TableColumn lampTypeColumn = new TableColumn(table, 0);
        lampTypeColumn.setText("Type");
        lampTypeColumn.setWidth(300);
        TableColumn lampLumenColumn = new TableColumn(table, 0);
        lampLumenColumn.setText("Total Lumen");
        lampLumenColumn.setWidth(100);
        TableColumn lampColorTempColumn = new TableColumn(table, 0);
        lampColorTempColumn.setText("Color Temp");
        lampColorTempColumn.setWidth(100);
        TableColumn lampCriColumn = new TableColumn(table, 0);
        lampCriColumn.setText("CRI");
        lampCriColumn.setWidth(100);
        TableColumn lampWattageColumn = new TableColumn(table, 0);
        lampWattageColumn.setText("Total Power");
        lampWattageColumn.setWidth(100);
        int index = this.addPage(this.lampsViewer.getControl());
        this.setPageText(index, "Lamps");
    }

    private void createLampSuggester() {
        if (!RegistrationController.isOKToUse(false)) {
            return;
        }
        IEditorInput input1 = this.getEditorInput();
        if (input1 instanceof FileEditorInput) {
            this.file = ((FileEditorInput)input1).getFile();
            this.suggester = LampManagerPool.getManager(this.file.getProject());
        } else {
            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), "Opening file from outside project", null, "When opening a file from outside a project, the Lamp Suggester is not available", 4, new String[]{"OK"}, 0);
            dialog.open();
            dialog.close();
        }
    }

    private void createLuminaireContextMenu() {
        MenuManager luminairePopupMgr = new MenuManager("#LuminairePopupMenu");
        luminairePopupMgr.setRemoveAllWhenShown(true);
        luminairePopupMgr.addMenuListener(manager -> this.fillLuminaireContextMenu(manager));
        Table table = this.luminaireViewer.getTable();
        Menu luminaireMenu = luminairePopupMgr.createContextMenu((Control)table);
        table.setMenu(luminaireMenu);
        this.getSite().registerContextMenu(luminairePopupMgr, (ISelectionProvider)this.luminaireViewer);
    }

    private void createCGammaContextMenu() {
        MenuManager cgammaPopupMgr = new MenuManager("#CGammaPopupMenu");
        cgammaPopupMgr.setRemoveAllWhenShown(true);
        cgammaPopupMgr.addMenuListener(manager -> this.fillCGammaContextMenu(manager));
        Table table = this.cgammaViewer.getTable();
        Menu cgammaMenu = cgammaPopupMgr.createContextMenu((Control)table);
        table.setMenu(cgammaMenu);
        this.getSite().registerContextMenu(cgammaPopupMgr, (ISelectionProvider)this.cgammaViewer);
    }

    private void createLampsContextMenu() {
        MenuManager lampPopupMgr = new MenuManager("#LampsPopupMenu");
        lampPopupMgr.setRemoveAllWhenShown(true);
        lampPopupMgr.addMenuListener(manager -> this.fillLampsContextMenu(manager));
        Table table = this.lampsViewer.getTable();
        Menu lampsMenu = lampPopupMgr.createContextMenu((Control)table);
        table.setMenu(lampsMenu);
        this.getSite().registerContextMenu(lampPopupMgr, (ISelectionProvider)this.lampsViewer);
    }

    protected void fillLampsContextMenu(IMenuManager manager) {
        manager.add(this.addLampAction);
        manager.add((IAction)this.removeInLampsAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillCGammaContextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyCGammaAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillLuminaireContextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyLuminaireAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.addLampAction);
        manager.add((IAction)this.removeInLuminaireAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void createCGammaActions() {
        ImageDescriptor copyImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY");
        this.copyCGammaAction = new CopyCGammaAction(this, this.cgammaViewer, "Copy CGamma", copyImage);
    }

    private void createLampsActions() {
        ImageDescriptor removeImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
        this.removeInLampsAction = new RemoveLampAction(this, this.lampsViewer, "Remove Lamp Set", removeImage);
    }

    private void createLuminaireActions() {
        ImageDescriptor addImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD");
        ImageDescriptor removeImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
        ImageDescriptor copyImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY");
        this.addLampAction = new AddLampAction(this, "Add Lamp Set", addImage);
        this.removeInLuminaireAction = new RemoveLampAction(this, this.luminaireViewer, "Remove Lamp Set", removeImage);
        this.copyLuminaireAction = new CopyLuminaireAction(this, this.luminaireViewer, "Copy Luminaire Description", copyImage);
    }

    private void createSourcePage() {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                if (this.file != null && !this.file.getProject().hasNature("com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature")) {
                    Logger.logError("Project should have Eulumdat Validator Nature", null);
                    Display.getDefault().asyncExec(() -> {
                        Shell shell = Display.getCurrent().getActiveShell();
                        MessageDialog.openWarning((Shell)shell, (String)"Eulumdat Validator Nature Not Set", (String)"This project doesn't have the Eulumdat Validator Nature set.\nTherefor the Lamp Suggester will not be available.");
                    });
                }
                this.textEditor = new EulumdatTextEditor((IDocumentProvider)new EulumdatDocumentProvider(), this.suggester);
                this.inProject = true;
            } else if (this.getEditorInput() instanceof FileStoreEditorInput) {
                this.textEditor = new EulumdatTextEditor((IDocumentProvider)new TextFileDocumentProvider(), this.suggester);
                this.inProject = false;
            }
            int index = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            this.setPartName(this.textEditor.getTitle());
            this.setPageText(index, "Source");
            IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
            document.addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    EulumdatEditor.this.parseEulumdat();
                    MenuUtils.performRefresh(EulumdatEditor.this.eulumdat.getIsym().toString());
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
        }
        catch (CoreException e) {
            Logger.logError("Problem creating Eulumdat Editor", e);
        }
    }

    private void createLuminairePage() {
        this.luminaireViewer = new TableViewer(this.getContainer(), 65538);
        Table table = this.luminaireViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.labelColumn = new TableColumn(table, 0);
        this.labelColumn.setText("Description");
        this.labelColumn.setWidth(300);
        this.valueColumn = new TableColumn(table, 0);
        this.valueColumn.setText("Value");
        this.valueColumn.setWidth(400);
        int index = this.addPage(this.luminaireViewer.getControl());
        this.setPageText(index, "Luminaire");
    }

    private void initLuminaireEditors() {
        this.luminaireViewer.setColumnProperties(new String[]{LABEL_COLUMN_ID, VALUE_COLUMN_ID});
        TextCellEditor valueEditor = new TextCellEditor((Composite)this.luminaireViewer.getTable());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = valueEditor;
        this.luminaireViewer.setCellEditors(cellEditorArray);
        this.luminaireViewer.setCellModifier((ICellModifier)new LuminaireEditorCellModifier(this));
    }

    private IContentProposalProvider getLampProposalProvider() {
        return (contents, position) -> {
            ILampVerifier suggester1 = LampManagerPool.getManager(this.file.getProject());
            List<String> suggestions = suggester1.suggest(contents.substring(0, position));
            IContentProposal[] proposals = new IContentProposal[suggestions.size()];
            int index = 0;
            for (final String suggestedLamp : suggestions) {
                proposals[index] = new IContentProposal(){

                    public String getContent() {
                        return suggestedLamp;
                    }

                    public String getLabel() {
                        return suggestedLamp;
                    }

                    public String getDescription() {
                        return null;
                    }

                    public int getCursorPosition() {
                        return suggestedLamp.length();
                    }
                };
                ++index;
            }
            return proposals;
        };
    }

    private void createCGammaPage() {
        this.cgammaViewer = new TableViewer(this.getContainer(), 65538);
        Table table = this.cgammaViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int index = this.addPage(this.cgammaViewer.getControl());
        this.setPageText(index, "C Gamma");
    }

    private void updateCGammaHeaders() {
        if (this.eulumdat != null) {
            Eulumdat2 cgamma = this.eulumdat;
            TableLayout layout = new TableLayout();
            int weight = 100 / (cgamma.getNoCPlaneValues() + 1);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(weight, 70, true));
            TableColumn column = new TableColumn(this.cgammaViewer.getTable(), 131072);
            column.setText("gamma");
            ArrayList<String> cLabels = Utils.createCPlaneLabels((ICGamma)cgamma);
            for (String label : cLabels) {
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(weight, 70, true));
                column = new TableColumn(this.cgammaViewer.getTable(), 0x1000000);
                column.setText(label);
            }
            this.cgammaViewer.getTable().setLayout((Layout)layout);
            this.cgammaViewer.getTable().layout(true, true);
            this.cgammaViewer.refresh();
        }
    }

    void updateTitle() {
        IEditorInput input1 = this.textEditor.getEditorInput();
        this.setPartName(input1.getName());
        this.setTitleToolTip(input1.getToolTipText());
    }

    private void createDiagramPage() {
        this.diagramComposite = new PhotometricDiagramViewer(this.getContainer());
        int index = this.addPage((Control)this.diagramComposite);
        this.setPageText(index, "Diagrams");
    }

    public void setFocus() {
        switch (this.getActivePage()) {
            case 0: {
                this.textEditor.setFocus();
                break;
            }
            case 1: {
                this.luminaireViewer.getTable().setFocus();
                break;
            }
            case 3: {
                this.cgammaViewer.getTable().setFocus();
                break;
            }
            case 2: {
                this.lampsViewer.getTable().setFocus();
                break;
            }
            case 4: {
                this.diagramComposite.setEulumdat(this.eulumdat);
                this.diagramComposite.setFocus();
                break;
            }
            default: {
                Logger.logError(NON_EXISTENT_PAGE, new IllegalStateException());
            }
        }
        if (this.eulumdat == null) {
            return;
        }
        MenuUtils.performRefresh(this.eulumdat.getIsym().toString());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        this.textEditor.getAdapter(IGotoMarker.class).gotoMarker(marker);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getActivePage() != 0) {
            this.updateTextFromEulumdat();
        }
        this.getEditor(0).doSave(monitor);
        this.updateTitle();
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setInput(editor.getEditorInput());
        this.updateTitle();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.diagramComposite != null) {
            this.diagramComposite.dispose();
        }
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
    }

    private void initLuminaireContent() {
        LuminaireContentProvider luminaireContentProvider = new LuminaireContentProvider();
        this.luminaireViewer.setContentProvider((IContentProvider)luminaireContentProvider);
        this.luminaireViewer.setLabelProvider((IBaseLabelProvider)new LuminaireLabelProvider());
        this.luminaireViewer.setInput((Object)this.eulumdat);
        this.luminaireViewer.getTable().getDisplay().asyncExec(() -> {
            this.parseEulumdat();
            this.updateLuminairePage(this.eulumdat);
        });
    }

    private void initCGammaContent() {
        CGammaContentProvider cgammaContentProvider = new CGammaContentProvider();
        this.cgammaViewer.setContentProvider((IContentProvider)cgammaContentProvider);
        this.cgammaViewer.setLabelProvider((IBaseLabelProvider)new CGammaLabelProvider());
        this.cgammaViewer.setInput((Object)this.eulumdat);
        this.cgammaViewer.getTable().getDisplay().asyncExec(() -> this.updateCGammaFromEulumdat(false));
    }

    private void updateCGammaFromEulumdat(boolean clearTable) {
        if (clearTable) {
            Table table = this.cgammaViewer.getTable();
            table.setRedraw(false);
            while (table.getColumnCount() > 0) {
                table.getColumn(0).dispose();
            }
            table.setRedraw(true);
            this.initCGammaContent();
        } else {
            this.cgammaViewer.setInput((Object)this.eulumdat);
            this.updateCGammaHeaders();
        }
    }

    private void updateLuminairePage(Eulumdat2 eu) {
        if (this.luminaireViewer != null) {
            this.luminaireViewer.setInput((Object)eu);
            this.labelColumn.pack();
            this.valueColumn.pack();
        }
    }

    protected void updateTextFromEulumdat() {
        if (this.eulumdat != null) {
            IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
            String newText = this.eulumdat.toString();
            if (!document.get().equals(newText)) {
                document.set(newText);
            }
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        switch (newPageIndex) {
            case 0: {
                this.parseEulumdat();
                if (!this.isDirty()) break;
                this.updateTextFromEulumdat();
                break;
            }
            case 1: {
                if (this.isDirty()) {
                    this.parseEulumdat();
                }
                this.updateLuminairePage(this.eulumdat);
                break;
            }
            case 3: {
                if (this.isDirty()) {
                    this.parseEulumdat();
                }
                this.updateCGammaFromEulumdat(this.isDirty());
                break;
            }
            case 2: {
                if (this.isDirty()) {
                    this.parseEulumdat();
                }
                this.updateLampsFromEulumdat(this.eulumdat);
                break;
            }
            case 4: {
                this.diagramComposite.setEulumdat(this.eulumdat);
                this.diagramComposite.redraw();
                break;
            }
            default: {
                Logger.logError(NON_EXISTENT_PAGE, null);
            }
        }
    }

    public ITextEditor getSourceEditor() {
        return this.textEditor;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(() -> {
                IWorkbenchPage[] pages;
                IWorkbenchPage[] iWorkbenchPageArray = pages = this.getSite().getWorkbenchWindow().getPages();
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage page = iWorkbenchPageArray[n2];
                    if (((FileEditorInput)this.textEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                        IEditorPart editorPart = page.findEditor(this.textEditor.getEditorInput());
                        page.closeEditor(editorPart, true);
                    }
                    ++n2;
                }
            });
        }
    }

    private void parseEulumdat() {
        if (this.eulumdat != null && !this.isDirty()) {
            this.updateOutlinePage();
        }
        IDocumentProvider docProvider = this.textEditor.getDocumentProvider();
        IEditorInput editorInput = this.textEditor.getEditorInput();
        String editorText = null;
        try {
            FileStoreEditorInput fsInput;
            String name;
            IEulumdatRO eu;
            boolean strict = ParserFactory.isStrict();
            ParserFactory.setStrict((boolean)false);
            if (editorInput instanceof IFileEditorInput) {
                editorText = docProvider.getDocument((Object)editorInput).get();
                if (editorText != null && editorText.length() > 0) {
                    this.eulumdat = EulumdatFactory.eulumdatFromBufferedReader((BufferedReader)new BufferedReader(new StringReader(editorText)), (String)editorInput.getName());
                }
            } else if (editorInput instanceof FileStoreEditorInput && (eu = EulumdatFactory.eulumdatROFromFilename((String)(name = URLDecoder.decode((fsInput = (FileStoreEditorInput)editorInput).getURI().getRawPath(), "UTF-8")))) instanceof Eulumdat2) {
                this.eulumdat = (Eulumdat2)eu;
            }
            if (this.eulumdat != null) {
                this.updateOutlinePage();
            }
            ParserFactory.setStrict((boolean)strict);
        }
        catch (IOException e) {
            Logger.logError("Problem reading Eulumdat", e);
        }
        catch (ParserException e) {
            Logger.logError("Problem parsing Eulumdat", e);
        }
    }

    private void updateOutlinePage() {
        if (this.outlinePage != null) {
            this.outlinePage.setInput(this.eulumdat);
        }
    }

    public void eulumdatChanged(int line) {
        if (this.eulumdat == null) {
            Logger.logError("Problem updating from EULUMDAT", null);
            return;
        }
        if (this.eulumdat.getNumberOfLampSets() >= 5) {
            this.addLampAction.setEnabled(false);
        } else {
            this.addLampAction.setEnabled(true);
        }
        this.updateTextFromEulumdat();
        if (line < 36 + 6 * this.eulumdat.getNumberOfLampSets()) {
            this.updateLuminairePage(this.eulumdat);
            this.updateLampsFromEulumdat(this.eulumdat);
        } else {
            this.updateCGammaFromEulumdat(false);
        }
        this.firePropertyChange(257);
        this.updateTitle();
    }

    public boolean isDirty() {
        return super.isDirty() && this.inProject;
    }

    public Eulumdat2 getEulumdat() {
        return this.eulumdat;
    }

    public IUndoContext getEulumdatUndoContext() {
        return this.eulumdatUndoContext;
    }

    public IOperationHistory getOperationHistory() {
        if (this.operationHistory == null) {
            this.operationHistory = OperationHistoryFactory.getOperationHistory();
        }
        return this.operationHistory;
    }

    public void setEulumdat(IEulumdatRO ro) {
        if (!(ro instanceof Eulumdat2)) {
            throw new IllegalArgumentException("input should be Eulumdat2 for now");
        }
        boolean redraw = this.eulumdat != null && (!ro.getIsym().equals((Object)this.eulumdat.getIsym()) || ro.getNoCPlanes() != this.eulumdat.getNoCPlanes());
        this.eulumdat = EulumdatFactory.eulumdatCopy((IEulumdatRO)ro);
        switch (this.getActivePage()) {
            case 0: {
                break;
            }
            case 1: {
                this.updateLuminairePage(this.eulumdat);
                break;
            }
            case 3: {
                this.updateCGammaFromEulumdat(redraw);
                this.cgammaViewer.refresh();
                break;
            }
            case 2: {
                this.updateLampsFromEulumdat(this.eulumdat);
                break;
            }
            case 4: {
                this.diagramComposite.setEulumdat(this.eulumdat);
                this.diagramComposite.redraw();
                break;
            }
            default: {
                Logger.logError(NON_EXISTENT_PAGE, null);
            }
        }
        this.updateTextFromEulumdat();
        this.updateOutlinePage();
    }

    public <T> T getAdapter(Class<T> required) {
        if (IContentOutlinePage.class.equals(required)) {
            if (this.getActivePage() == 0 && this.outlinePage == null) {
                this.outlinePage = (EulumdatOutlinePage)((Object)this.getActiveEditor().getAdapter(required));
                return (T)((Object)this.outlinePage);
            }
            return null;
        }
        if (IEulumdatRO.class.equals(required)) {
            if (this.eulumdat != null) {
                return (T)this.eulumdat;
            }
            return null;
        }
        return (T)super.getAdapter(required);
    }

    public void selectLampEditor() {
        this.pageChange(2);
    }

    public void saveState(IMemento memento) {
        if (memento == null) {
            return;
        }
        String id = this.getSite().getId();
        IMemento child = memento.createChild(id);
        if (child == null) {
            return;
        }
        child.putInteger("page", this.getActivePage());
        this.textEditor.saveState(child);
    }

    public void restoreState(IMemento memento) {
        this.savedMemento = memento;
    }

    public void restoreFromMemento(IMemento memento) {
        if (memento == null) {
            return;
        }
        String id = this.getSite().getId();
        System.out.println(id);
        IMemento child = memento.getChild(id);
        if (child == null) {
            return;
        }
        Integer val = child.getInteger("page");
        int mementoActivePage = val != null ? val : 0;
        this.setActivePage(mementoActivePage);
        this.textEditor.restoreState(child);
    }
}

