/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat;

import com.fold1.data.ICGamma;
import com.fold1.eulumdat.tools.editors.eulumdat.AbstractCopyAction;
import com.fold1.eulumdat.tools.editors.eulumdat.CGammaContentProvider;
import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatEditor;
import com.fold1.eulumdat.tools.utils.Utils;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;

public class CopyCGammaAction
extends AbstractCopyAction {
    TableViewer cgammaViewer;

    public CopyCGammaAction(EulumdatEditor editor, TableViewer viewer, String text, ImageDescriptor image) {
        super(text, image, editor);
        this.cgammaViewer = viewer;
    }

    public void run() {
        String text = this.cgammaToText();
        this.textToClipboard(text);
    }

    private String cgammaToText() {
        StringBuffer text = new StringBuffer("gamma\t");
        if (this.cgammaViewer != null) {
            TableViewer tv = this.cgammaViewer;
            assert (tv != null);
            CGammaContentProvider cp = (CGammaContentProvider)tv.getContentProvider();
            assert (cp != null);
            Object input = this.cgammaViewer.getInput();
            assert (input != null);
            Object[] rows = cp.getElements(input);
            int count = 0;
            ArrayList<String> cPlaneLabels = Utils.createCPlaneLabels((ICGamma)this.getEditor().eulumdat);
            for (String cPlaneLabel : cPlaneLabels) {
                text.append(cPlaneLabel);
                if (count < cPlaneLabels.size() - 1) {
                    text.append("\t");
                    ++count;
                    continue;
                }
                text.append(System.lineSeparator());
            }
            if (rows != null) {
                Object[] objectArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    Object row2 = objectArray[n2];
                    if (row2 instanceof Object[]) {
                        Object[] row = (Object[])row2;
                        int cplane = 0;
                        while (cplane < row.length) {
                            Object object = row[cplane];
                            if (object instanceof String) {
                                text.append((String)object);
                                if (cplane < row.length - 1) {
                                    text.append("\t");
                                } else {
                                    text.append(System.lineSeparator());
                                }
                            }
                            ++cplane;
                        }
                    }
                    ++n2;
                }
            }
        }
        return text.toString();
    }
}

