/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.eulumdat;

import com.fold1.data.IEulumdatRO;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.util.NumberOutput;
import java.text.DecimalFormat;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class CGammaContentProvider
implements IStructuredContentProvider {
    private static final String UNDEFINED = "undef";

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IEulumdatRO) {
            IEulumdatRO cgamma = (IEulumdatRO)inputElement;
            Object[] result = new Object[cgamma.getNg()];
            int gammaIndex = 0;
            while (gammaIndex < cgamma.getNg()) {
                Object[] row = new Object[cgamma.getNoCPlaneValues() + 1];
                try {
                    row[0] = NumberOutput.localDigits((double)cgamma.getAngleGamma(gammaIndex), (int)1);
                }
                catch (IllegalArgumentException e1) {
                    Logger.logError("Problem creating row", e1);
                    row[0] = UNDEFINED;
                }
                int cIndex = 0;
                while (cIndex < cgamma.getNoCPlaneValues()) {
                    try {
                        row[cIndex + 1] = UNDEFINED;
                        double intensity = cgamma.getRawValue(cIndex, gammaIndex);
                        row[cIndex + 1] = new DecimalFormat("#.####").format(intensity);
                    }
                    catch (IllegalArgumentException e) {
                        Logger.logError("Problem creating row", e);
                    }
                    ++cIndex;
                }
                result[gammaIndex] = row;
                ++gammaIndex;
            }
            return result;
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

