/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.converter.text;

import com.fold1.eulumdat.tools.editors.converter.text.DocumentLampSuggester;
import com.fold1.eulumdat.tools.lamps.ILampSuggester;
import com.fold1.eulumdat.tools.log.Logger;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;

public class LegalLampAssistProcessor
implements IContentAssistProcessor {
    private static final char[] LAMPCHARACTERS = new char[]{'\'', ' ', '.', ',', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-'};
    private ContextInformationValidator validator;
    private String lastError = null;
    private ILampSuggester suggester;

    public LegalLampAssistProcessor(ILampSuggester suggester) {
        this.suggester = suggester;
    }

    public LegalLampAssistProcessor() {
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (!(viewer instanceof ISourceViewer)) {
            return null;
        }
        IDocument document = viewer.getDocument();
        int currOffset = offset - 1;
        if (this.suggester == null) {
            this.suggester = new DocumentLampSuggester(document);
        }
        try {
            char currChar;
            StringBuilder lampStart = new StringBuilder();
            StringBuilder lampEnd = new StringBuilder();
            while (currOffset > 0 && '\'' != (currChar = document.getChar(currOffset)) && !LegalLampAssistProcessor.lampBreakChar(currChar)) {
                lampStart.append(currChar);
                --currOffset;
            }
            lampStart.reverse();
            while (currOffset > 0 && '\'' != (currChar = document.getChar(currOffset)) && !LegalLampAssistProcessor.lampBreakChar(currChar)) {
                lampEnd.append(currChar);
                ++currOffset;
            }
            List<String> suggestions = this.suggester.suggest(lampStart.toString(), lampEnd.toString());
            ICompletionProposal[] proposals = null;
            if (!suggestions.isEmpty()) {
                proposals = LegalLampAssistProcessor.buildProposals(suggestions, lampStart.toString() + lampEnd.toString(), offset - lampStart.length());
                this.lastError = null;
            }
            return proposals;
        }
        catch (BadLocationException e) {
            this.lastError = e.getMessage();
            Logger.logError("Problem with autocompletion", e);
            return null;
        }
    }

    private static boolean lampBreakChar(char currChar) {
        return '\"' == currChar || '\r' == currChar || '\n' == currChar;
    }

    private static ICompletionProposal[] buildProposals(List<String> suggestions, String replacedWord, int offset) {
        ICompletionProposal[] proposals = new ICompletionProposal[suggestions.size()];
        int index = 0;
        for (String suggestedLamp : suggestions) {
            proposals[index] = new CompletionProposal(suggestedLamp, offset, replacedWord.length(), suggestedLamp.length());
            ++index;
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return Arrays.copyOf(LAMPCHARACTERS, LAMPCHARACTERS.length);
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.validator == null) {
            this.validator = new ContextInformationValidator((IContentAssistProcessor)this);
        }
        return this.validator;
    }

    public String getErrorMessage() {
        return this.lastError;
    }
}

