/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.converter.text;

import com.fold1.eulumdat.tools.lamps.ILampSuggester;
import com.fold1.eulumdat.tools.lamps.LampManager;
import com.fold1.eulumdat.tools.log.Logger;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class DocumentLampSuggester
implements ILampSuggester,
IDocumentListener {
    private TreeSet<String> legal;
    private IDocument doc;

    private DocumentLampSuggester() {
    }

    public DocumentLampSuggester(IDocument doc) {
        this.doc = doc;
        doc.addDocumentListener((IDocumentListener)this);
    }

    private void initLegalLamps(String content) {
        this.legal = new TreeSet();
        BufferedReader in = new BufferedReader(new StringReader(content));
        LampManager.readLampConversions(in, this.legal);
    }

    @Override
    public List<String> suggest(String lamp) {
        return this.suggest(lamp, "");
    }

    @Override
    public List<String> suggest(String lampStart, String lampEnd) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (this.getDoc() == null) {
            return suggestions;
        }
        if (this.legal == null) {
            this.initLegalLamps(this.getDoc().get());
        }
        for (String legalLamp : this.legal) {
            if (!legalLamp.startsWith(lampStart) || legalLamp.equals(lampStart)) continue;
            suggestions.add(legalLamp);
        }
        return suggestions;
    }

    protected IDocument getDoc() {
        if (this.doc == null) {
            Logger.logError("Conversion document not initialized", null);
        }
        return this.doc;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.initLegalLamps(this.getDoc().get());
        if (Platform.inDevelopmentMode()) {
            Logger.logInfo("Conversion document re-initialzied");
        }
    }
}

