/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.converter;

import com.fold1.eulumdat.tools.editors.converter.AbstractConversionElement;
import com.fold1.eulumdat.tools.editors.converter.ConversionCategory;
import com.fold1.eulumdat.tools.editors.converter.ConversionEntry;
import com.fold1.eulumdat.tools.editors.converter.ConversionFile;
import java.util.Arrays;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class RemoveConversionOperation
extends AbstractOperation {
    private static final String REMOVE_PROPERTIES = "Remove properties";
    private final TreeViewer viewer;
    private final AbstractConversionElement[] elements;
    private AbstractConversionElement[] parents;
    private int[] indexes;

    public RemoveConversionOperation(TreeViewer viewer, AbstractConversionElement[] elements) {
        super(RemoveConversionOperation.getLabelFor(elements));
        this.viewer = viewer;
        this.elements = Arrays.copyOf(elements, elements.length);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Shell shell;
        if (info != null && (shell = (Shell)info.getAdapter(Shell.class)) != null && !MessageDialog.openQuestion((Shell)shell, (String)REMOVE_PROPERTIES, (String)"Do you want to remove the currently selected properties?")) {
            return Status.CANCEL_STATUS;
        }
        return this.redo(monitor, info);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.parents = new AbstractConversionElement[this.elements.length];
        this.indexes = new int[this.elements.length];
        if (monitor != null) {
            monitor.beginTask(REMOVE_PROPERTIES, this.elements.length);
        }
        Tree tree = this.viewer.getTree();
        tree.setRedraw(false);
        try {
            int i = this.elements.length;
            while (--i >= 0) {
                this.parents[i] = this.elements[i].getParent();
                AbstractConversionElement[] children = this.parents[i].getChildren();
                int index = 0;
                while (index < children.length) {
                    if (children[index] == this.elements[i]) {
                        this.indexes[i] = index;
                        break;
                    }
                    ++index;
                }
                this.elements[i].removeFromParent();
                if (monitor == null) continue;
                monitor.worked(1);
            }
        }
        finally {
            tree.setRedraw(true);
        }
        if (monitor != null) {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        Tree tree = this.viewer.getTree();
        tree.setRedraw(false);
        try {
            int i = 0;
            while (i < this.elements.length) {
                if (this.parents[i] instanceof ConversionCategory) {
                    ((ConversionCategory)this.parents[i]).addEntry(this.indexes[i], (ConversionEntry)this.elements[i]);
                } else {
                    ((ConversionFile)this.parents[i]).addCategory(this.indexes[i], (ConversionCategory)this.elements[i]);
                }
                ++i;
            }
        }
        finally {
            tree.setRedraw(true);
        }
        return Status.OK_STATUS;
    }

    private static String getLabelFor(AbstractConversionElement[] elements) {
        if (elements.length == 1) {
            AbstractConversionElement first = elements[0];
            if (first instanceof ConversionEntry) {
                ConversionEntry propEntry = (ConversionEntry)first;
                return "Remove property " + propEntry.getKey();
            }
            if (first instanceof ConversionCategory) {
                ConversionCategory propCat = (ConversionCategory)first;
                return "Remove category " + propCat.getName();
            }
        }
        return REMOVE_PROPERTIES;
    }
}

