/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.converter;

import com.fold1.eulumdat.tools.editors.converter.AbstractConversionElement;
import com.fold1.eulumdat.tools.editors.converter.ConverterEditor;
import com.fold1.eulumdat.tools.editors.converter.RemoveConversionOperation;
import com.fold1.eulumdat.tools.log.Logger;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class RemoveConversionAction
extends Action {
    private final ConverterEditor editor;
    private final TreeViewer viewer;
    private final ISelectionChangedListener listener = e -> this.setEnabled(!e.getSelection().isEmpty());

    public RemoveConversionAction(ConverterEditor editor, TreeViewer viewer, String text, ImageDescriptor imageDescriptor) {
        super(text, imageDescriptor);
        this.editor = editor;
        this.viewer = viewer;
        this.setEnabled(false);
        viewer.addSelectionChangedListener(this.listener);
    }

    public void run() {
        ITreeSelection sel = this.viewer.getStructuredSelection();
        Iterator iter = sel.iterator();
        int size = sel.size();
        AbstractConversionElement[] elements = new AbstractConversionElement[size];
        int i = 0;
        while (i < size) {
            elements[i] = (AbstractConversionElement)iter.next();
            ++i;
        }
        RemoveConversionOperation op = new RemoveConversionOperation(this.viewer, elements);
        op.addContext(this.editor.getUndoContext());
        IProgressMonitor monitor = this.editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
        IAdaptable info = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (Shell.class.equals((Object)adapter)) {
                    return RemoveConversionAction.this.editor.getSite().getShell();
                }
                return null;
            }
        };
        try {
            try {
                ConverterEditor.getOperationHistory().execute((IUndoableOperation)op, monitor, info);
            }
            catch (ExecutionException e) {
                Logger.logError("Exception while removing properties: " + e.getMessage(), e);
                MessageDialog.openError((Shell)this.editor.getSite().getShell(), (String)"Remove Conversion Error", (String)("Exception while removing properties: " + e.getMessage()));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

