/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.converter;

import com.fold1.eulumdat.tools.editors.converter.ConverterEditor;
import com.fold1.eulumdat.tools.log.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.LabelRetargetAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;

public class ConverterEditorContributor
extends EditorActionBarContributor {
    private static final String[] WORKBENCH_ACTION_IDS = new String[]{ActionFactory.DELETE.getId(), ActionFactory.UNDO.getId(), ActionFactory.REDO.getId(), ActionFactory.CUT.getId(), ActionFactory.COPY.getId(), ActionFactory.PASTE.getId(), ActionFactory.SELECT_ALL.getId(), ActionFactory.FIND.getId(), IDEActionFactory.BOOKMARK.getId()};
    private static final String[] TEXTEDITOR_ACTION_IDS = new String[]{ActionFactory.DELETE.getId(), ActionFactory.UNDO.getId(), ActionFactory.REDO.getId(), ActionFactory.CUT.getId(), ActionFactory.COPY.getId(), ActionFactory.PASTE.getId(), ActionFactory.SELECT_ALL.getId(), ActionFactory.FIND.getId(), IDEActionFactory.BOOKMARK.getId()};
    private LabelRetargetAction retargetRemoveAction = new LabelRetargetAction(ActionFactory.DELETE.getId(), "Remove");

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        page.addPartListener((IPartListener)this.retargetRemoveAction);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        MenuManager menu = new MenuManager("Converter Editor");
        menuManager.prependToGroup("additions", (IContributionItem)menu);
        menu.add((IAction)this.retargetRemoveAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.retargetRemoveAction);
    }

    public void dispose() {
        this.getPage().removePartListener((IPartListener)this.retargetRemoveAction);
        super.dispose();
    }

    public void setActiveEditor(IEditorPart part) {
        ConverterEditor editor = (ConverterEditor)part;
        this.setActivePage(editor, editor.getActivePage());
    }

    public void setActivePage(ConverterEditor editor, int pageIndex) {
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            switch (pageIndex) {
                case 0: {
                    ConverterEditorContributor.hookGlobalTreeActions(editor, actionBars);
                    break;
                }
                case 1: {
                    ConverterEditorContributor.hookGlobalTextActions(editor, actionBars);
                    break;
                }
                default: {
                    Logger.logError("Non existent page!", null);
                }
            }
            actionBars.updateActionBars();
        }
    }

    private static void hookGlobalTreeActions(ConverterEditor editor, IActionBars actionBars) {
        String[] stringArray = WORKBENCH_ACTION_IDS;
        int n = WORKBENCH_ACTION_IDS.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            actionBars.setGlobalActionHandler(element, editor.getTreeAction(element));
            ++n2;
        }
    }

    private static void hookGlobalTextActions(ConverterEditor editor, IActionBars actionBars) {
        ITextEditor textEditor = editor.getSourceEditor();
        int i = 0;
        while (i < WORKBENCH_ACTION_IDS.length) {
            actionBars.setGlobalActionHandler(WORKBENCH_ACTION_IDS[i], textEditor.getAction(TEXTEDITOR_ACTION_IDS[i]));
            ++i;
        }
    }
}

