/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.converter;

import com.fold1.eulumdat.tools.editors.converter.ConversionCategory;
import com.fold1.eulumdat.tools.editors.converter.ConversionEntry;
import com.fold1.eulumdat.tools.editors.converter.ConversionFile;
import com.fold1.eulumdat.tools.editors.converter.ConversionFileListener;
import com.fold1.eulumdat.tools.editors.converter.ConverterEditorCellModifier;
import com.fold1.eulumdat.tools.editors.converter.ConverterEditorContentProvider;
import com.fold1.eulumdat.tools.editors.converter.ConverterEditorContributor;
import com.fold1.eulumdat.tools.editors.converter.ConverterEditorLabelProvider;
import com.fold1.eulumdat.tools.editors.converter.RemoveConversionAction;
import com.fold1.eulumdat.tools.editors.converter.text.ConverterTextEditor;
import com.fold1.eulumdat.tools.log.Logger;
import java.util.HashSet;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ConverterEditor
extends MultiPageEditorPart
implements IGotoMarker,
IResourceChangeListener,
IPersistableEditor {
    public static final String VALUE_COLUMN_ID = "Value";
    public static final String KEY_COLUMN_ID = "Key";
    private static final int SOURCEPAGE = 0;
    private static final int TABLEPAGE = 1;
    private IFile file;
    private ConverterTextEditor textEditor;
    private TreeViewer treeViewer;
    private TreeColumn keyColumn;
    private boolean isAltPressed;
    private boolean isPageModified;
    private RemoveConversionAction removeAction;
    private UndoActionHandler undoAction;
    private RedoActionHandler redoAction;
    private IUndoContext undoContext;
    private final HashSet<String> recentAdditions;
    private final ConversionFileListener conversionFileListener = new ConversionFileListener(){

        @Override
        public void keyChanged(ConversionCategory category, ConversionEntry entry) {
            ConverterEditor.this.treeViewer.update((Object)entry, new String[]{ConverterEditor.KEY_COLUMN_ID});
            ConverterEditor.this.treeModified();
        }

        @Override
        public void valueChanged(ConversionCategory category, ConversionEntry entry) {
            ConverterEditor.this.treeViewer.update((Object)entry, new String[]{ConverterEditor.VALUE_COLUMN_ID});
            ConverterEditor.this.treeModified();
        }

        @Override
        public void nameChanged(ConversionCategory category) {
            ConverterEditor.this.treeViewer.update((Object)category, new String[]{ConverterEditor.KEY_COLUMN_ID});
            ConverterEditor.this.treeModified();
        }

        @Override
        public void entryAdded(ConversionCategory category, ConversionEntry entry) {
            ConverterEditor.this.treeViewer.refresh();
            ConverterEditor.this.treeModified();
        }

        @Override
        public void entryRemoved(ConversionCategory category, ConversionEntry entry) {
            ConverterEditor.this.treeViewer.refresh();
            ConverterEditor.this.treeModified();
        }

        @Override
        public void categoryAdded(ConversionCategory category) {
            ConverterEditor.this.treeViewer.refresh();
            ConverterEditor.this.treeModified();
        }

        @Override
        public void categoryRemoved(ConversionCategory category) {
            ConverterEditor.this.treeViewer.refresh();
            ConverterEditor.this.treeModified();
        }
    };
    private final Object outlinePage = null;
    private IMemento savedMemento;

    public ConverterEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.recentAdditions = new HashSet();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
        this.recentAdditions.clear();
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
        this.recentAdditions.clear();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createPages() {
        this.createSourcePage();
        this.createTablePage();
        this.updateTitle();
        this.initTreeContent();
        this.initTreeEditors();
        this.createActions();
        this.createContextMenu();
        this.restoreFromMemento(this.savedMemento);
    }

    private void createTablePage() {
        this.treeViewer = new TreeViewer(this.getContainer(), 65538);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        this.keyColumn = new TreeColumn(tree, 0);
        this.keyColumn.setText("When in EULUMDAT:");
        this.keyColumn.setWidth(300);
        TreeColumn valueColumn = new TreeColumn(tree, 0);
        valueColumn.setText("Convert to:");
        valueColumn.setWidth(300);
        int index = this.addPage(this.treeViewer.getControl());
        this.setPageText(index, "Simple");
    }

    void updateTitle() {
        IEditorInput input = this.getEditorInput();
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getToolTipText());
    }

    void initTreeContent() {
        ConverterEditorContentProvider treeContentProvider = new ConverterEditorContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConverterEditorLabelProvider());
        this.treeViewer.setInput((Object)new ConversionFile(""));
        this.treeViewer.getTree().getDisplay().asyncExec(() -> this.updateTreeFromTextEditor());
        this.treeViewer.setAutoExpandLevel(-1);
    }

    private void initTreeEditors() {
        this.treeViewer.setColumnProperties(new String[]{KEY_COLUMN_ID, VALUE_COLUMN_ID});
        final TextCellEditor keyEditor = new TextCellEditor((Composite)this.treeViewer.getTree());
        TextCellEditor valueEditor = new TextCellEditor((Composite)this.treeViewer.getTree());
        keyEditor.setValidator(value -> {
            if (((String)value).trim().length() == 0) {
                return "Key must not be empty string";
            }
            return null;
        });
        valueEditor.setValidator(value -> null);
        keyEditor.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                this.setErrorMessage(null);
            }

            public void cancelEditor() {
                this.setErrorMessage(null);
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                this.setErrorMessage(keyEditor.getErrorMessage());
            }

            void setErrorMessage(String errorMessage) {
                ConverterEditor.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(errorMessage);
            }
        });
        this.treeViewer.setCellEditors(new CellEditor[]{keyEditor, valueEditor});
        this.treeViewer.setCellModifier((ICellModifier)new ConverterEditorCellModifier(this, this.treeViewer));
        this.treeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 65536) {
                    ConverterEditor.this.isAltPressed = true;
                }
                if (e.character == '\u007f') {
                    ConverterEditor.this.removeAction.run();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 65536) {
                    ConverterEditor.this.isAltPressed = false;
                }
            }
        });
    }

    private void createActions() {
        this.undoContext = new ObjectUndoContext((Object)this);
        this.undoAction = new UndoActionHandler(this.getSite(), this.undoContext);
        this.redoAction = new RedoActionHandler(this.getSite(), this.undoContext);
        ImageDescriptor removeImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
        this.removeAction = new RemoveConversionAction(this, this.treeViewer, "Remove", removeImage);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(m -> this.fillContextMenu(m));
        Tree tree = this.treeViewer.getTree();
        Menu menu = menuMgr.createContextMenu((Control)tree);
        tree.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        menuMgr.add((IAction)this.undoAction);
        menuMgr.add((IAction)this.redoAction);
        menuMgr.add((IContributionItem)new Separator());
        boolean isEmpty = this.treeViewer.getSelection().isEmpty();
        this.removeAction.setEnabled(!isEmpty);
        menuMgr.add((IAction)this.removeAction);
        menuMgr.add((IContributionItem)new Separator("additions"));
    }

    void updateTreeFromTextEditor() {
        ConversionFile conversionFile = (ConversionFile)this.treeViewer.getInput();
        conversionFile.removeConversionFileListener(this.conversionFileListener);
        conversionFile = new ConversionFile(this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput()).get());
        this.treeViewer.setInput((Object)conversionFile);
        conversionFile.addConversionFileListener(this.conversionFileListener);
    }

    void updateTextEditorFromTree() {
        this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput()).set(((ConversionFile)this.treeViewer.getInput()).asText());
    }

    public void treeModified() {
        boolean wasDirty = this.isDirty();
        this.isPageModified = true;
        if (!wasDirty) {
            this.handleConversionChange(257);
        }
    }

    public boolean shouldEdit() {
        if (!this.isAltPressed) {
            return false;
        }
        this.isAltPressed = false;
        return true;
    }

    protected void handleConversionChange(int conversionId) {
        if (conversionId == 257) {
            this.isPageModified = this.isDirty();
        }
    }

    public boolean isDirty() {
        return this.isPageModified || super.isDirty();
    }

    protected void pageChange(int newPageIndex) {
        switch (newPageIndex) {
            case 1: {
                if (!this.isDirty()) break;
                this.updateTreeFromTextEditor();
                break;
            }
            case 0: {
                if (!this.isPageModified) break;
                this.updateTextEditorFromTree();
                break;
            }
            default: {
                Logger.logError("Non existent page!", null);
            }
        }
        this.isPageModified = false;
        super.pageChange(newPageIndex);
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof ConverterEditorContributor) {
            ((ConverterEditorContributor)contributor).setActivePage(this, newPageIndex);
        }
    }

    public ITextEditor getSourceEditor() {
        return this.textEditor;
    }

    public IAction getTreeAction(String workbenchActionId) {
        if (ActionFactory.UNDO.getId().equals(workbenchActionId)) {
            return this.undoAction;
        }
        if (ActionFactory.REDO.getId().equals(workbenchActionId)) {
            return this.redoAction;
        }
        if (ActionFactory.DELETE.getId().equals(workbenchActionId)) {
            return this.removeAction;
        }
        return null;
    }

    public void setFocus() {
        switch (this.getActivePage()) {
            case 1: {
                this.treeViewer.getTree().setFocus();
                break;
            }
            case 0: {
                this.textEditor.setFocus();
                break;
            }
            default: {
                Logger.logError("Non existent page!", null);
            }
        }
    }

    void createSourcePage() {
        try {
            this.textEditor = new ConverterTextEditor();
            int index = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            this.setPartName(this.textEditor.getTitle());
            this.setPageText(index, "Source");
        }
        catch (PartInitException e) {
            Logger.logError("Problem creating Lamp Converter Editor", e);
        }
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        ((IGotoMarker)this.textEditor.getAdapter(IGotoMarker.class)).gotoMarker(marker);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(() -> {
                IWorkbenchPage[] pages;
                IWorkbenchPage[] iWorkbenchPageArray = pages = this.getSite().getWorkbenchWindow().getPages();
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage page = iWorkbenchPageArray[n2];
                    if (((FileEditorInput)this.textEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                        IEditorPart editorPart = page.findEditor(this.textEditor.getEditorInput());
                        page.closeEditor(editorPart, true);
                    }
                    ++n2;
                }
            });
        }
    }

    public static IOperationHistory getOperationHistory() {
        return OperationHistoryFactory.getOperationHistory();
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    public void appendConversion(String from, String to) {
        String editorText = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput()).get();
        int index = editorText.length();
        if (!this.recentAdditions.contains(from)) {
            StringBuffer extra = new StringBuffer(System.lineSeparator());
            extra.append("'" + from + "'=>'" + to + "'");
            index += extra.indexOf("=>");
            this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput()).set(editorText + extra.toString());
            this.recentAdditions.add(from);
        }
        this.textEditor.selectAndReveal(index + 3, to.length());
    }

    public void changeConversion(String from, String to) {
        String editorText = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput()).get();
        int index = editorText.indexOf("'" + from + "'=>");
        index += from.length() + 4;
        if (to.length() > 0) {
            ++index;
        }
        this.textEditor.selectAndReveal(index, to.length());
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlinePage == null && Platform.inDevelopmentMode()) {
                Logger.logInfo("Outline Page requested for " + ((Object)((Object)this)).getClass().getName());
            }
            return this.outlinePage;
        }
        return super.getAdapter(required);
    }

    void setFile(IFile file) {
        this.file = file;
    }

    IFile getFile() {
        return this.file;
    }

    public void saveState(IMemento memento) {
        if (memento == null) {
            return;
        }
        String id = this.getSite().getId();
        IMemento child = memento.createChild(id);
        if (child == null) {
            return;
        }
        child.putInteger("page", this.getActivePage());
        this.textEditor.saveState(child);
    }

    public void restoreState(IMemento memento) {
        this.savedMemento = memento;
    }

    public void restoreFromMemento(IMemento memento) {
        if (memento == null) {
            return;
        }
        String id = this.getSite().getId();
        System.out.println(id);
        IMemento child = memento.getChild(id);
        if (child == null) {
            return;
        }
        Integer val = child.getInteger("page");
        int mementoActivePage = val != null ? val : 0;
        this.setActivePage(mementoActivePage);
        this.textEditor.restoreState(child);
    }
}

