/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.converter;

import com.fold1.eulumdat.tools.editors.converter.AbstractConversionElement;
import com.fold1.eulumdat.tools.editors.converter.ConversionCategory;
import com.fold1.eulumdat.tools.editors.converter.ConversionEntry;
import com.fold1.eulumdat.tools.editors.converter.ConversionFileListener;
import com.fold1.eulumdat.tools.log.Logger;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class ConversionFile
extends AbstractConversionElement {
    private ConversionCategory unnamedCategory;
    private final List<ConversionCategory> categories;
    private final List<ConversionFileListener> listeners = new ArrayList<ConversionFileListener>();

    public ConversionFile(String content) {
        super(null);
        this.categories = new ArrayList<ConversionCategory>();
        LineNumberReader reader = new LineNumberReader(new StringReader(content));
        try {
            this.unnamedCategory = new ConversionCategory(this, reader);
            while (true) {
                reader.mark(1);
                int ch = reader.read();
                if (ch != -1) {
                    reader.reset();
                    this.categories.add(new ConversionCategory(this, reader));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Logger.logError("Error reading almp conversion file", e);
        }
    }

    @Override
    public AbstractConversionElement[] getChildren() {
        ArrayList<AbstractConversionElement> children = new ArrayList<AbstractConversionElement>();
        children.addAll(this.unnamedCategory.getEntries());
        children.addAll(this.categories);
        return children.toArray(new AbstractConversionElement[children.size()]);
    }

    public void addCategory(ConversionCategory category) {
        this.addCategory(this.categories.size(), category);
    }

    public void addCategory(int index, ConversionCategory category) {
        if (!this.categories.contains(category)) {
            this.categories.add(index, category);
            this.categoryAdded(category);
        }
    }

    public void removeCategory(ConversionCategory category) {
        if (this.categories.remove(category)) {
            this.categoryRemoved(category);
        }
    }

    @Override
    public void removeFromParent() {
    }

    void addConversionFileListener(ConversionFileListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    void removeConversionFileListener(ConversionFileListener listener) {
        this.listeners.remove(listener);
    }

    void keyChanged(ConversionCategory category, ConversionEntry entry) {
        for (ConversionFileListener listener : this.listeners) {
            listener.keyChanged(category, entry);
        }
    }

    void valueChanged(ConversionCategory category, ConversionEntry entry) {
        for (ConversionFileListener listener : this.listeners) {
            listener.valueChanged(category, entry);
        }
    }

    void nameChanged(ConversionCategory category) {
        for (ConversionFileListener listener : this.listeners) {
            listener.nameChanged(category);
        }
    }

    void entryAdded(ConversionCategory category, ConversionEntry entry) {
        for (ConversionFileListener listener : this.listeners) {
            listener.entryAdded(category, entry);
        }
    }

    void entryRemoved(ConversionCategory category, ConversionEntry entry) {
        for (ConversionFileListener listener : this.listeners) {
            listener.entryRemoved(category, entry);
        }
    }

    void categoryAdded(ConversionCategory category) {
        for (ConversionFileListener listener : this.listeners) {
            listener.categoryAdded(category);
        }
    }

    void categoryRemoved(ConversionCategory category) {
        for (ConversionFileListener listener : this.listeners) {
            listener.categoryRemoved(category);
        }
    }

    public String asText() {
        StringWriter stringWriter = new StringWriter(2000);
        PrintWriter writer = new PrintWriter(stringWriter);
        this.unnamedCategory.appendText(writer);
        for (ConversionCategory category : this.categories) {
            writer.println();
            category.appendText(writer);
        }
        return stringWriter.toString();
    }
}

