/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.editors.converter;

import com.fold1.eulumdat.tools.editors.converter.AbstractConversionElement;
import com.fold1.eulumdat.tools.editors.converter.ConversionEntry;
import com.fold1.eulumdat.tools.editors.converter.ConversionFile;
import com.fold1.util.StringUtils;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConversionCategory
extends AbstractConversionElement {
    private String name;
    private List<ConversionEntry> entries;

    public ConversionCategory(ConversionFile parent, LineNumberReader reader) throws IOException {
        super(parent);
        String line;
        int ch;
        while (true) {
            reader.mark(1);
            ch = reader.read();
            if (ch == -1) break;
            reader.reset();
            if (ch != 35) break;
            line = reader.readLine();
            if (this.name != null || (line = line.replace('#', ' ').trim()).length() <= 0) continue;
            this.name = line;
        }
        if (this.name == null) {
            this.name = "";
        }
        this.entries = new ArrayList<ConversionEntry>();
        while (true) {
            reader.mark(1);
            ch = reader.read();
            if (ch == -1) break;
            reader.reset();
            if (ch == 35) break;
            line = reader.readLine();
            if (line == null) {
                return;
            }
            int index = line.indexOf("=>");
            if (index == -1) continue;
            String key = line.substring(0, index).trim();
            String value = line.substring(index + 2).trim();
            this.entries.add(new ConversionEntry(this, StringUtils.unquote((String)key), StringUtils.unquote((String)value)));
        }
    }

    public String getName() {
        return this.name;
    }

    public Collection<ConversionEntry> getEntries() {
        return this.entries;
    }

    @Override
    public AbstractConversionElement[] getChildren() {
        return this.entries.toArray(new AbstractConversionElement[this.entries.size()]);
    }

    public void setName(String text) {
        if (this.name.equals(text)) {
            return;
        }
        this.name = text;
        ((ConversionFile)this.getParent()).nameChanged(this);
    }

    public void addEntry(ConversionEntry entry) {
        this.addEntry(this.entries.size(), entry);
    }

    public void addEntry(int index, ConversionEntry entry) {
        if (!this.entries.contains(entry)) {
            this.entries.add(index, entry);
            ((ConversionFile)this.getParent()).entryAdded(this, entry);
        }
    }

    public void removeEntry(ConversionEntry entry) {
        if (this.entries.remove(entry)) {
            ((ConversionFile)this.getParent()).entryRemoved(this, entry);
        }
    }

    @Override
    public void removeFromParent() {
        ((ConversionFile)this.getParent()).removeCategory(this);
    }

    public void keyChanged(ConversionEntry entry) {
        ((ConversionFile)this.getParent()).keyChanged(this, entry);
    }

    public void valueChanged(ConversionEntry entry) {
        ((ConversionFile)this.getParent()).valueChanged(this, entry);
    }

    public void appendText(PrintWriter writer) {
        if (this.name.length() > 0) {
            writer.println();
            writer.print("# ");
            writer.println(this.name);
        }
        for (ConversionEntry entry : this.entries) {
            entry.appendText(writer);
        }
    }
}

